/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.fx;

import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.render.FXRenders;

@SideOnly(value=Side.CLIENT)
public class FXPortalFloater
extends Particle {
    public static final int particleId = 5;
    public static final ResourceLocation texture = new ResourceLocation("aoa3", "fx/portal_floater");
    private final double originPosX;
    private final double originPosY;
    private final double originPosZ;

    public FXPortalFloater(World world, double posX, double posY, double posZ, double speedX, double speedY, double speedZ, int colour, float ... scale) {
        super(world, posX, posY, posZ, speedX, speedY, speedZ);
        this.originPosX = posX;
        this.originPosY = posY;
        this.originPosZ = posZ;
        this.field_187129_i = speedX;
        this.field_187130_j = speedY;
        this.field_187131_k = speedZ;
        this.field_70544_f = this.field_187136_p.nextFloat() * 0.07f;
        if (scale.length > 0) {
            this.field_70544_f *= scale[0];
        }
        this.field_70547_e = (int)(Math.random() * 10.0) + 40;
        this.field_70552_h = (float)(colour >> 16) / 255.0f;
        this.field_70553_i = (float)(colour >> 8 & 0xFF) / 255.0f;
        this.field_70551_j = (float)(colour & 0xFF) / 255.0f;
        this.field_82339_as = 1.0f;
        this.func_187117_a(Minecraft.func_71410_x().func_147117_R().getTextureExtry(texture.toString()));
        this.func_70536_a((int)(Math.random() * 8.0));
    }

    public int func_70537_b() {
        return this.field_187119_C == null ? 1 : 0;
    }

    public boolean func_187111_c() {
        return false;
    }

    public void func_187110_a(double x, double y, double z) {
        this.func_187108_a(this.func_187116_l().func_72317_d(x, y, z));
        this.func_187118_j();
    }

    public void func_189213_a() {
        float percentAged = (float)this.field_70546_d / (float)this.field_70547_e;
        float ageModifier = 1.0f - (-percentAged + percentAged * percentAged * 2.0f);
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        this.field_187126_f = this.originPosX + this.field_187129_i * (double)ageModifier;
        this.field_187127_g = this.originPosY + this.field_187130_j * (double)ageModifier + (double)(1.0f - percentAged);
        this.field_187128_h = this.originPosZ + this.field_187131_k * (double)ageModifier;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(BufferBuilder buffer, Entity entity, float partialTick, float edgeLRdirectionX, float edgeUDdirectionY, float edgeLRdirectionZ, float edgeUDdirectionX, float edgeUDdirectionZ) {
        double minU = (float)this.field_94054_b / 16.0f;
        double maxU = minU + (double)0.0624375f;
        double minV = (float)this.field_94055_c / 16.0f;
        double maxV = minV + (double)0.0624375f;
        double x = this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTick - field_70556_an;
        double y = this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTick - field_70554_ao;
        double z = this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTick - field_70555_ap;
        float scaleMod = 1.0f - ((float)this.field_70546_d + partialTick) / (float)this.field_70547_e;
        scaleMod *= scaleMod;
        scaleMod = 1.0f - scaleMod;
        double scale = scaleMod * this.field_70544_f;
        double scaledUDDirX = (double)edgeUDdirectionX * scale;
        double scaledUDDirY = (double)edgeUDdirectionY * scale;
        double scaledUDDirZ = (double)edgeUDdirectionZ * scale;
        double scaledLRDirX = (double)edgeLRdirectionX * scale;
        double scaledLRDirZ = (double)edgeLRdirectionZ * scale;
        int combinedBrightness = this.func_189214_a(partialTick);
        int skyLightTimes16 = combinedBrightness >> 16 & 0xFFFF;
        int blockLightTimes16 = combinedBrightness & 0xFFFF;
        buffer.func_181662_b(x - scaledLRDirX - scaledUDDirX, y - scaledUDDirY, z - scaledLRDirZ - scaledUDDirZ).func_187315_a(maxU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
        buffer.func_181662_b(x - scaledLRDirX + scaledUDDirX, y + scaledUDDirY, z - scaledLRDirZ + scaledUDDirZ).func_187315_a(maxU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
        buffer.func_181662_b(x + scaledLRDirX + scaledUDDirX, y + scaledUDDirY, z + scaledLRDirZ + scaledUDDirZ).func_187315_a(minU, minV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
        buffer.func_181662_b(x + scaledLRDirX - scaledUDDirX, y - scaledUDDirY, z + scaledLRDirZ - scaledUDDirZ).func_187315_a(minU, maxV).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(skyLightTimes16, blockLightTimes16).func_181675_d();
    }

    public int func_189214_a(float p_189214_1_) {
        int initialBrightness = super.func_189214_a(p_189214_1_);
        double percentAged = Math.pow((float)this.field_70546_d / (float)this.field_70547_e, 3.0);
        int brightnessLowerBits = initialBrightness & 0xFF;
        int brightnessUpperBits = initialBrightness >> 16 & 0xFF;
        brightnessUpperBits = Math.min(brightnessUpperBits + (int)(percentAged * 240.0), 240);
        return brightnessLowerBits | brightnessUpperBits << 16;
    }

    public void create() {
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)this);
    }

    @SideOnly(value=Side.CLIENT)
    public static class Factory
    implements FXRenders.FXFactory {
        @Override
        @Nullable
        public Particle createParticle(double posX, double posY, double posZ, double velocityX, double velocityY, double velocityZ, int textureOffsetIndex, float scale, int ... args) {
            FXPortalFloater particle = new FXPortalFloater((World)Minecraft.func_71410_x().field_71441_e, posX, posY, posZ, velocityX, velocityY, velocityZ, textureOffsetIndex, scale);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)particle);
            return particle;
        }
    }
}

