/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerMerchant;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.client.gui.blocks.BasicBlockGui;
import net.tslat.aoa3.client.gui.blocks.GuiDivineStation;
import net.tslat.aoa3.client.gui.blocks.GuiFrameBench;
import net.tslat.aoa3.client.gui.blocks.GuiInfusion;
import net.tslat.aoa3.client.gui.mainwindow.AdventMainGui;
import net.tslat.aoa3.client.gui.merchants.BankerGui;
import net.tslat.aoa3.client.gui.merchants.CorruptedTravellerGui;
import net.tslat.aoa3.client.gui.merchants.TraderGui;
import net.tslat.aoa3.client.gui.misc.WornBookGui;
import net.tslat.aoa3.client.gui.realmstonegui.GuiRealmstoneChallengeMenu;
import net.tslat.aoa3.common.containers.ContainerBankerTrade;
import net.tslat.aoa3.common.containers.ContainerCorruptedTraveller;
import net.tslat.aoa3.common.containers.ContainerDivineStation;
import net.tslat.aoa3.common.containers.ContainerFrameBench;
import net.tslat.aoa3.common.containers.ContainerInfusionTable;
import net.tslat.aoa3.common.containers.ContainerMendingTable;
import net.tslat.aoa3.common.containers.ContainerWhitewashingTable;
import net.tslat.aoa3.entity.base.AoATrader;
import net.tslat.aoa3.entity.npcs.banker.EntityCreepBanker;
import net.tslat.aoa3.entity.npcs.banker.EntityLelyetianBanker;
import net.tslat.aoa3.entity.npcs.banker.EntityPrimordialBanker;
import net.tslat.aoa3.entity.npcs.banker.EntityShyreBanker;
import net.tslat.aoa3.entity.npcs.banker.EntityZalBanker;
import net.tslat.aoa3.entity.npcs.lottoman.EntityLottoman;
import net.tslat.aoa3.entity.npcs.skillmaster.EntitySkillMaster;
import net.tslat.aoa3.entity.npcs.trader.EntityAssassin;
import net.tslat.aoa3.entity.npcs.trader.EntityCorruptedTraveller;
import net.tslat.aoa3.entity.npcs.trader.EntityCrystalTrader;
import net.tslat.aoa3.entity.npcs.trader.EntityDungeonKeeper;
import net.tslat.aoa3.entity.npcs.trader.EntityExplosivesExpert;
import net.tslat.aoa3.entity.npcs.trader.EntityGorbArmsDealer;
import net.tslat.aoa3.entity.npcs.trader.EntityGorbEngineer;
import net.tslat.aoa3.entity.npcs.trader.EntityLelyetianTrader;
import net.tslat.aoa3.entity.npcs.trader.EntityMetalloid;
import net.tslat.aoa3.entity.npcs.trader.EntityNaturalist;
import net.tslat.aoa3.entity.npcs.trader.EntityPrimordialMerchant;
import net.tslat.aoa3.entity.npcs.trader.EntityPrimordialSpellbinder;
import net.tslat.aoa3.entity.npcs.trader.EntityPrimordialWizard;
import net.tslat.aoa3.entity.npcs.trader.EntityProfessor;
import net.tslat.aoa3.entity.npcs.trader.EntityRealmshifter;
import net.tslat.aoa3.entity.npcs.trader.EntityShyreArcher;
import net.tslat.aoa3.entity.npcs.trader.EntityStoreKeeper;
import net.tslat.aoa3.entity.npcs.trader.EntityTokenCollector;
import net.tslat.aoa3.entity.npcs.trader.EntityToyMerchant;
import net.tslat.aoa3.entity.npcs.trader.EntityTrollTrader;
import net.tslat.aoa3.entity.npcs.trader.EntityUndeadHerald;
import net.tslat.aoa3.entity.npcs.trader.EntityZalGrocer;
import net.tslat.aoa3.entity.npcs.trader.EntityZalHerbalist;
import net.tslat.aoa3.entity.npcs.trader.EntityZalSpellbinder;
import net.tslat.aoa3.entity.npcs.trader.EntityZalVendor;
import net.tslat.aoa3.item.misc.WornBook;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;

public class GuiManager
implements IGuiHandler {
    public Object getServerGuiElement(int guiId, EntityPlayer player, World world, int x, int y, int z) {
        Enums.ModGuis gui = Enums.ModGuis.getById(guiId);
        if (gui != null) {
            switch (gui) {
                case TRADER_ASSASSIN: {
                    return this.getTraderContainer(player, EntityAssassin.class, x);
                }
                case TRADER_CORRUPTED_TRAVELLER: {
                    return new ContainerCorruptedTraveller(player, this.getNearbyEntityGuiTarget(player, EntityCorruptedTraveller.class, x));
                }
                case TRADER_CREEP_BANKER: {
                    return this.getTraderContainer(player, EntityCreepBanker.class, x);
                }
                case TRADER_CRYSTAL_TRADER: {
                    return this.getTraderContainer(player, EntityCrystalTrader.class, x);
                }
                case TRADER_DUNGEON_KEEPER: {
                    return this.getTraderContainer(player, EntityDungeonKeeper.class, x);
                }
                case TRADER_EXPLOSIVES_EXPERT: {
                    return this.getTraderContainer(player, EntityExplosivesExpert.class, x);
                }
                case TRADER_GORB_ARMS_DEALER: {
                    return this.getTraderContainer(player, EntityGorbArmsDealer.class, x);
                }
                case TRADER_GORB_ENGINEER: {
                    return this.getTraderContainer(player, EntityGorbEngineer.class, x);
                }
                case TRADER_LELYETIAN_BANKER: {
                    return this.getTraderContainer(player, EntityLelyetianBanker.class, x);
                }
                case TRADER_LELYETIAN_TRADER: {
                    return this.getTraderContainer(player, EntityLelyetianTrader.class, x);
                }
                case TRADER_LOTTOMAN: {
                    return this.getTraderContainer(player, EntityLottoman.class, x);
                }
                case TRADER_METALLOID: {
                    return this.getTraderContainer(player, EntityMetalloid.class, x);
                }
                case TRADER_NATURALIST: {
                    return this.getTraderContainer(player, EntityNaturalist.class, x);
                }
                case TRADER_PRIMORDIAL_BANKER: {
                    return this.getTraderContainer(player, EntityPrimordialBanker.class, x);
                }
                case TRADER_PRIMORDIAL_MERCHANT: {
                    return this.getTraderContainer(player, EntityPrimordialMerchant.class, x);
                }
                case TRADER_PRIMORDIAL_SPELLBINDER: {
                    return this.getTraderContainer(player, EntityPrimordialSpellbinder.class, x);
                }
                case TRADER_PRIMORDIAL_WIZARD: {
                    return this.getTraderContainer(player, EntityPrimordialWizard.class, x);
                }
                case TRADER_PROFESSOR: {
                    return this.getTraderContainer(player, EntityProfessor.class, x);
                }
                case TRADER_REALMSHIFTER: {
                    return this.getTraderContainer(player, EntityRealmshifter.class, x);
                }
                case TRADER_SHYRE_ARCHER: {
                    return this.getTraderContainer(player, EntityShyreArcher.class, x);
                }
                case TRADER_SHYRE_BANKER: {
                    return this.getTraderContainer(player, EntityShyreBanker.class, x);
                }
                case TRADER_SKILL_MASTER: {
                    return this.getTraderContainer(player, EntitySkillMaster.class, x);
                }
                case TRADER_UNDEAD_HERALD: {
                    return this.getTraderContainer(player, EntityUndeadHerald.class, x);
                }
                case TRADER_STORE_KEEPER: {
                    return this.getTraderContainer(player, EntityStoreKeeper.class, x);
                }
                case TRADER_TOKEN_COLLECTOR: {
                    return this.getTraderContainer(player, EntityTokenCollector.class, x);
                }
                case TRADER_TOY_MERCHANT: {
                    return this.getTraderContainer(player, EntityToyMerchant.class, x);
                }
                case TRADER_TROLL_TRADER: {
                    return this.getTraderContainer(player, EntityTrollTrader.class, x);
                }
                case TRADER_ZAL_BANKER: {
                    return this.getTraderContainer(player, EntityZalBanker.class, x);
                }
                case TRADER_ZAL_GROCER: {
                    return this.getTraderContainer(player, EntityZalGrocer.class, x);
                }
                case TRADER_ZAL_HERBALIST: {
                    return this.getTraderContainer(player, EntityZalHerbalist.class, x);
                }
                case TRADER_ZAL_SPELLBINDER: {
                    return this.getTraderContainer(player, EntityZalSpellbinder.class, x);
                }
                case TRADER_ZAL_VENDOR: {
                    return this.getTraderContainer(player, EntityZalVendor.class, x);
                }
                case INFUSION_TABLE: {
                    return new ContainerInfusionTable(player, player.field_70170_p, new BlockPos(x, y, z));
                }
                case FRAME_BENCH: {
                    return new ContainerFrameBench(player, player.field_70170_p, new BlockPos(x, y, z));
                }
                case MENDING_TABLE: {
                    return new ContainerMendingTable(player, player.field_70170_p, new BlockPos(x, y, z));
                }
                case DIVINE_STATION: {
                    return new ContainerDivineStation(player, player.field_70170_p, new BlockPos(x, y, z));
                }
                case WHITEWASHING_TABLE: {
                    return new ContainerWhitewashingTable(player, player.field_70170_p, new BlockPos(x, y, z));
                }
                case BANKER: {
                    return new ContainerBankerTrade(player, this.getNearbyEntityGuiTarget(player, AoATrader.class, x));
                }
            }
            return null;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Object getClientGuiElement(int guiId, EntityPlayer player, World world, int x, int y, int z) {
        Enums.ModGuis gui = Enums.ModGuis.getById(guiId);
        if (gui != null) {
            switch (gui) {
                case WORN_BOOK: {
                    return new WornBookGui(player, WornBook.getBook(), false);
                }
                case TRADER_ASSASSIN: {
                    return this.getTraderGui(player, EntityAssassin.class, x, "assassin_trade");
                }
                case TRADER_CORRUPTED_TRAVELLER: {
                    EntityCorruptedTraveller traveller = this.getNearbyEntityGuiTarget(player, EntityCorruptedTraveller.class, x);
                    return new CorruptedTravellerGui(new ContainerCorruptedTraveller(player, traveller), traveller);
                }
                case TRADER_CREEP_BANKER: {
                    return this.getTraderGui(player, EntityCreepBanker.class, x, "creep_banker_trade");
                }
                case TRADER_CRYSTAL_TRADER: {
                    return this.getTraderGui(player, EntityCrystalTrader.class, x, "crystal_trader_trade");
                }
                case TRADER_DUNGEON_KEEPER: {
                    return this.getTraderGui(player, EntityDungeonKeeper.class, x, "dungeon_keeper_trade");
                }
                case TRADER_EXPLOSIVES_EXPERT: {
                    return this.getTraderGui(player, EntityExplosivesExpert.class, x, "explosives_expert_trade");
                }
                case TRADER_GORB_ARMS_DEALER: {
                    return this.getTraderGui(player, EntityGorbArmsDealer.class, x, "gorb_trade");
                }
                case TRADER_GORB_ENGINEER: {
                    return this.getTraderGui(player, EntityGorbEngineer.class, x, "gorb_trade");
                }
                case TRADER_LELYETIAN_BANKER: {
                    return this.getTraderGui(player, EntityLelyetianBanker.class, x, "lelyetian_trade");
                }
                case TRADER_LELYETIAN_TRADER: {
                    return this.getTraderGui(player, EntityLelyetianTrader.class, x, "lelyetian_trade");
                }
                case TRADER_LOTTOMAN: {
                    return this.getTraderGui(player, EntityLottoman.class, x, "lottoman_trade");
                }
                case TRADER_METALLOID: {
                    return this.getTraderGui(player, EntityMetalloid.class, x, "metalloid_trade");
                }
                case TRADER_NATURALIST: {
                    return this.getTraderGui(player, EntityNaturalist.class, x, "naturalist_trade");
                }
                case TRADER_PRIMORDIAL_BANKER: {
                    return this.getTraderGui(player, EntityPrimordialBanker.class, x, "primordial_trade");
                }
                case TRADER_PRIMORDIAL_MERCHANT: {
                    return this.getTraderGui(player, EntityPrimordialMerchant.class, x, "primordial_trade");
                }
                case TRADER_PRIMORDIAL_SPELLBINDER: {
                    return this.getTraderGui(player, EntityPrimordialSpellbinder.class, x, "primordial_trade");
                }
                case TRADER_PRIMORDIAL_WIZARD: {
                    return this.getTraderGui(player, EntityPrimordialWizard.class, x, "primordial_trade");
                }
                case TRADER_PROFESSOR: {
                    return this.getTraderGui(player, EntityProfessor.class, x, "professor_trade");
                }
                case TRADER_REALMSHIFTER: {
                    return this.getTraderGui(player, EntityRealmshifter.class, x, "realmshifter_trade");
                }
                case TRADER_SHYRE_ARCHER: {
                    return this.getTraderGui(player, EntityShyreArcher.class, x, "shyre_archer_trade");
                }
                case TRADER_SHYRE_BANKER: {
                    return this.getTraderGui(player, EntityShyreBanker.class, x, "shyre_banker_trade");
                }
                case TRADER_SKILL_MASTER: {
                    return this.getTraderGui(player, EntitySkillMaster.class, x, "skill_master_trade");
                }
                case TRADER_UNDEAD_HERALD: {
                    return this.getTraderGui(player, EntityUndeadHerald.class, x, "undead_herald_trade");
                }
                case TRADER_STORE_KEEPER: {
                    return this.getTraderGui(player, EntityStoreKeeper.class, x, "store_keeper_trade");
                }
                case TRADER_TOKEN_COLLECTOR: {
                    return this.getTraderGui(player, EntityTokenCollector.class, x, "token_collector_trade");
                }
                case TRADER_TOY_MERCHANT: {
                    return this.getTraderGui(player, EntityToyMerchant.class, x, "toy_merchant_trade");
                }
                case TRADER_TROLL_TRADER: {
                    return this.getTraderGui(player, EntityTrollTrader.class, x, "troll_trader_trade");
                }
                case TRADER_ZAL_BANKER: {
                    return this.getTraderGui(player, EntityZalBanker.class, x, "zal_trade");
                }
                case TRADER_ZAL_GROCER: {
                    return this.getTraderGui(player, EntityZalGrocer.class, x, "zal_trade");
                }
                case TRADER_ZAL_HERBALIST: {
                    return this.getTraderGui(player, EntityZalHerbalist.class, x, "zal_trade");
                }
                case TRADER_ZAL_SPELLBINDER: {
                    return this.getTraderGui(player, EntityZalSpellbinder.class, x, "zal_trade");
                }
                case TRADER_ZAL_VENDOR: {
                    return this.getTraderGui(player, EntityZalVendor.class, x, "zal_trade");
                }
                case ADVENT_MAIN_WINDOW: {
                    return new AdventMainGui(player);
                }
                case INFUSION_TABLE: {
                    return new GuiInfusion(player);
                }
                case FRAME_BENCH: {
                    return new GuiFrameBench(player);
                }
                case MENDING_TABLE: {
                    return new BasicBlockGui(player, StringUtil.getLocaleString("tile.MendingTable.name"), new ContainerMendingTable(player, world, BlockPos.field_177992_a));
                }
                case WHITEWASHING_TABLE: {
                    return new BasicBlockGui(player, StringUtil.getLocaleString("tile.WhitewashingTable.name"), new ContainerWhitewashingTable(player, world, BlockPos.field_177992_a));
                }
                case DIVINE_STATION: {
                    return new GuiDivineStation(player, StringUtil.getLocaleString("tile.DivineStation.name"), new ContainerDivineStation(player, world, BlockPos.field_177992_a));
                }
                case REALMSTONE_MENU: {
                    return new GuiRealmstoneChallengeMenu();
                }
                case BANKER: {
                    AoATrader banker = this.getNearbyEntityGuiTarget(player, AoATrader.class, x);
                    if (banker == null) {
                        return null;
                    }
                    return new BankerGui(new ContainerBankerTrade(player, banker), banker);
                }
            }
            return null;
        }
        return null;
    }

    private ContainerMerchant getTraderContainer(EntityPlayer pl, Class<? extends AoATrader> traderClass, int entityId) {
        AoATrader trader = this.getNearbyEntityGuiTarget(pl, traderClass, entityId);
        if (trader != null) {
            return new ContainerMerchant(pl.field_71071_by, (IMerchant)trader, pl.field_70170_p);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private Object getTraderGui(EntityPlayer pl, Class<? extends AoATrader> traderClass, int entityId, String guiName) {
        AoATrader trader = this.getNearbyEntityGuiTarget(pl, traderClass, entityId);
        if (trader != null) {
            return new TraderGui(new ContainerMerchant(pl.field_71071_by, (IMerchant)trader, pl.field_70170_p), trader, guiName);
        }
        return null;
    }

    @Nullable
    private <T extends Entity> T getNearbyEntityGuiTarget(EntityPlayer player, Class<? extends T> entityClass, int entityId) {
        for (Entity e : player.field_70170_p.func_72872_a(entityClass, player.func_174813_aQ().func_186662_g(10.0))) {
            if (e.func_145782_y() != entityId) continue;
            return (T)e;
        }
        return null;
    }
}

