/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.gui.lib;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public abstract class ScrollablePane {
    private Minecraft mc;
    protected int top;
    protected int bottom;
    protected int left;
    protected int right;
    protected int viewWidth;
    protected int viewHeight;
    protected int scrollBarHeight;
    private float currentRenderScale;
    protected int mouseX;
    protected int mouseY;
    private boolean mouseFocussed;
    private float mouseYPosState = -2.0f;
    protected float distanceScrolled;
    private float scrollFactor;

    public ScrollablePane(Minecraft mc, int top, int left, int viewHeight, int viewWidth, float ... renderingScale) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewWidth = viewWidth;
        this.viewHeight = viewHeight;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
        if (renderingScale.length > 0) {
            this.currentRenderScale = renderingScale[0];
        }
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        int scrollBarWidth = 6;
        this.mouseFocussed = this.isMouseHovering();
        int paneHeight = this.getFullPaneHeight();
        int paneViewDiff = paneHeight - this.viewHeight;
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder buff = tess.func_178180_c();
        if (paneViewDiff > 0) {
            this.scrollBarHeight = (int)MathHelper.func_76131_a((float)((float)(this.viewHeight * this.viewHeight) / (float)paneHeight), (float)32.0f, (float)this.viewHeight);
        }
        if (Mouse.isButtonDown((int)0)) {
            if (this.mouseYPosState == -1.0f) {
                if (this.mouseFocussed) {
                    if (mouseX >= this.right - scrollBarWidth && mouseX <= this.right) {
                        this.scrollFactor = -1.0f;
                        int scrollHeight = Math.max(paneHeight - this.viewHeight, 1);
                        this.scrollFactor /= (float)(this.viewHeight - this.scrollBarHeight) / (float)scrollHeight;
                    } else {
                        this.scrollFactor = 1.0f;
                    }
                    this.mouseYPosState = mouseY;
                } else {
                    this.mouseYPosState = -2.0f;
                }
            } else if (this.mouseYPosState >= 0.0f) {
                this.distanceScrolled -= ((float)mouseY - this.mouseYPosState) * this.scrollFactor;
                this.mouseYPosState = mouseY;
            }
        } else {
            this.mouseYPosState = -1.0f;
        }
        this.distanceScrolled = MathHelper.func_76131_a((float)this.distanceScrolled, (float)0.0f, (float)(paneHeight - this.viewHeight));
        GL11.glEnable((int)3089);
        ScaledResolution res = new ScaledResolution(this.mc);
        float windowWidthScale = this.currentRenderScale * ((float)this.mc.field_71443_c / (float)res.func_78327_c());
        float windowHeightScale = this.currentRenderScale * ((float)this.mc.field_71440_d / (float)res.func_78324_d());
        GL11.glScissor((int)((int)(((double)this.left - 1.5) * (double)windowWidthScale)), (int)((int)(((float)this.mc.field_71440_d / windowHeightScale - (float)this.bottom) * windowHeightScale)), (int)((int)((float)(this.viewWidth + 3) * windowWidthScale)), (int)((int)(((double)this.viewHeight + 1.5) * (double)windowHeightScale)));
        this.drawBackground();
        GuiUtils.drawGradientRect((int)0, (int)(this.left - 1), (int)(this.top - 1), (int)(this.right + 1), (int)(this.bottom + 1), (int)-1072689136, (int)-804253680);
        int newTop = this.top - Math.max(0, (int)this.distanceScrolled);
        this.drawPaneContents(newTop, this.left, this.right, this.bottom, this.distanceScrolled);
        GlStateManager.func_179097_i();
        if (paneViewDiff > 0) {
            int barTop = Math.max((int)this.distanceScrolled * (this.viewHeight - this.scrollBarHeight) / paneViewDiff + this.top, this.top);
            int barLeft = this.right - 6;
            GlStateManager.func_179090_x();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_181662_b((double)barLeft, (double)this.bottom, 0.0).func_187315_a(0.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buff.func_181662_b((double)(this.right + 1), (double)this.bottom, 0.0).func_187315_a(1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buff.func_181662_b((double)(this.right + 1), (double)this.top, 0.0).func_187315_a(1.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            buff.func_181662_b((double)barLeft, (double)this.top, 0.0).func_187315_a(0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_181662_b((double)barLeft, (double)(barTop + this.scrollBarHeight), 0.0).func_187315_a(0.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buff.func_181662_b((double)(this.right + 1), (double)(barTop + this.scrollBarHeight), 0.0).func_187315_a(1.0, 1.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buff.func_181662_b((double)(this.right + 1), (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            buff.func_181662_b((double)barLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(128, 128, 128, 255).func_181675_d();
            tess.func_78381_a();
            buff.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            buff.func_181662_b((double)barLeft, (double)(barTop + this.scrollBarHeight - 1), 0.0).func_187315_a(0.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buff.func_181662_b((double)this.right, (double)(barTop + this.scrollBarHeight - 1), 0.0).func_187315_a(1.0, 1.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buff.func_181662_b((double)this.right, (double)barTop, 0.0).func_187315_a(1.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            buff.func_181662_b((double)barLeft, (double)barTop, 0.0).func_187315_a(0.0, 0.0).func_181669_b(192, 192, 192, 255).func_181675_d();
            tess.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179141_d();
        GlStateManager.func_179084_k();
        GL11.glDisable((int)3089);
    }

    public void onResize(Minecraft mc, int left, int top, int viewWidth, int viewHeight) {
        this.mc = mc;
        this.top = top;
        this.left = left;
        this.viewHeight = viewHeight;
        this.viewWidth = viewWidth;
        this.bottom = top + viewHeight;
        this.right = left + viewWidth;
    }

    public void handleMouseInput(int mouseX, int mouseY) {
        if (!this.mouseFocussed) {
            return;
        }
        int scrollAmount = Mouse.getEventDWheel();
        if (scrollAmount != 0) {
            this.distanceScrolled += (float)(-1 * scrollAmount) / 10.0f;
        }
    }

    private boolean isMouseHovering() {
        return this.mouseX >= this.left && this.mouseX <= this.right && this.mouseY >= this.top && this.mouseY <= this.bottom;
    }

    public abstract int getFullPaneHeight();

    public abstract void drawPaneContents(int var1, int var2, int var3, int var4, float var5);

    public abstract void drawBackground();
}

