/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.client.model.entities.animations;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.client.model.entities.animations.ModelAnimatable;
import net.tslat.aoa3.entity.base.AnimatableEntity;
import net.tslat.aoa3.utils.ModUtil;
import org.apache.logging.log4j.Level;

@SideOnly(value=Side.CLIENT)
public class EntityAnimation {
    public static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(Builder.class, (json, type, context) -> Builder.deserialize(JsonUtils.func_151210_l((JsonElement)json, (String)"animations"), context)).create();
    private final float animationLength;
    private final ArrayList<BoneAnimation> animations;
    private final boolean loop;

    protected EntityAnimation(float animationLength, ArrayList<BoneAnimation> animations, boolean loop) {
        this.animationLength = animationLength;
        this.animations = animations;
        this.loop = loop;
    }

    protected EntityAnimation(int animationLength, ArrayList<BoneAnimation> animations) {
        this(animationLength, animations, false);
    }

    protected void animate(AnimatableEntity entity, int animationTicks, float partialTicks) {
        if (entity.getCurrentAnimationTicks() < 0 && this.loop) {
            entity.resetAnimation();
        }
        if (this.animations == null || (float)animationTicks > this.animationLength) {
            if (this.loop && (float)animationTicks > this.animationLength) {
                entity.resetAnimation();
            } else {
                entity.finishAnimation();
            }
            return;
        }
        for (BoneAnimation animation : this.animations) {
            animation.rotate(animationTicks, partialTicks);
        }
    }

    public static class Builder {
        private final HashSet<HashMap<String, Object>> semiParsedElementsMap;

        Builder(@Nonnull HashSet<HashMap<String, Object>> partiallyDigestedMap) {
            this.semiParsedElementsMap = partiallyDigestedMap;
        }

        public void build(ModelAnimatable baseModel) {
            String animationName = null;
            float animationLength = 0.0f;
            ArrayList<BoneAnimation> boneAnimations = new ArrayList<BoneAnimation>();
            boolean loop = false;
            for (HashMap<String, Object> animationMap : this.semiParsedElementsMap) {
                for (Map.Entry<String, Object> entry : animationMap.entrySet()) {
                    block8 : switch (entry.getKey()) {
                        case "name": {
                            animationName = (String)entry.getValue();
                            break;
                        }
                        case "animation_length": {
                            animationLength = ((Float)entry.getValue()).floatValue();
                            break;
                        }
                        case "loop": {
                            loop = true;
                            break;
                        }
                        case "bones": {
                            for (Map.Entry boneEntry : (Set)entry.getValue()) {
                                try {
                                    Field boneField = ReflectionHelper.findField(((Object)((Object)baseModel)).getClass(), (String[])new String[]{(String)boneEntry.getKey()});
                                    Object boneObject = boneField.get((Object)baseModel);
                                    if (ModelRenderer.class.isAssignableFrom(boneObject.getClass())) {
                                        float[] keyframeRotations;
                                        float[] keyframes;
                                        ModelRenderer bone = (ModelRenderer)boneObject;
                                        JsonObject boneDetails = ((JsonElement)boneEntry.getValue()).getAsJsonObject();
                                        if (!boneDetails.has("rotation")) {
                                            throw new JsonSyntaxException("No rotation information for animated bone section. Skipping animation");
                                        }
                                        JsonElement boneRotationObject = boneDetails.get("rotation");
                                        try {
                                            if (boneRotationObject.isJsonObject()) {
                                                Set rotationDetails = boneRotationObject.getAsJsonObject().entrySet();
                                                keyframes = ModUtil.initFixedArray(rotationDetails.size());
                                                keyframeRotations = ModUtil.initFixedArray((float)rotationDetails.size() * 3.0f);
                                                int i = 0;
                                                for (Map.Entry rotationDetail : rotationDetails) {
                                                    JsonArray keyFrameRotationArray = ((JsonElement)rotationDetail.getValue()).getAsJsonArray();
                                                    keyframes[i] = Float.parseFloat((String)rotationDetail.getKey()) * 20.0f;
                                                    keyframeRotations[i * 3] = (float)Math.toRadians(keyFrameRotationArray.get(0).getAsJsonPrimitive().getAsFloat());
                                                    keyframeRotations[i * 3 + 1] = (float)Math.toRadians(keyFrameRotationArray.get(1).getAsJsonPrimitive().getAsFloat());
                                                    keyframeRotations[i * 3 + 2] = (float)Math.toRadians(keyFrameRotationArray.get(2).getAsJsonPrimitive().getAsFloat());
                                                    ++i;
                                                }
                                            } else {
                                                keyframes = new float[]{0.0f};
                                                JsonArray boneRotationArray = boneRotationObject.getAsJsonArray();
                                                keyframeRotations = ModUtil.initFixedArray(boneRotationArray.size());
                                                for (int i = 0; i < boneRotationArray.size(); ++i) {
                                                    keyframeRotations[i] = boneRotationArray.get(i).getAsJsonPrimitive().getAsFloat();
                                                }
                                            }
                                        }
                                        catch (IndexOutOfBoundsException ex) {
                                            AdventOfAscension.logMessage(Level.WARN, "Oddly malformed rotation instruction in animation file for " + ((Object)((Object)baseModel)).getClass().getName() + ": " + animationName);
                                            break block8;
                                        }
                                        boneAnimations.add(new BoneAnimation(bone, keyframes, keyframeRotations));
                                        continue;
                                    }
                                    AdventOfAscension.logMessage(Level.WARN, "Model field " + (String)boneEntry.getKey() + " is not a valid ModelRenderer field, unable to parse animation details");
                                }
                                catch (IllegalAccessException ex) {
                                    AdventOfAscension.logMessage(Level.WARN, "Bone model field has invalid access modifier: " + ((Object)((Object)baseModel)).getClass().toString() + "#" + (String)boneEntry.getKey());
                                }
                                catch (JsonSyntaxException ex) {
                                    AdventOfAscension.logMessage(Level.WARN, "Malformed JSON for animation file");
                                    ex.printStackTrace();
                                }
                                catch (NumberFormatException ex) {
                                    AdventOfAscension.logMessage(Level.WARN, "Invalid number format for timing or rotation for entity animation");
                                    ex.printStackTrace();
                                }
                                catch (IllegalStateException ex) {
                                    AdventOfAscension.logMessage(Level.WARN, "JSON Object received in an unexpected format");
                                    ex.printStackTrace();
                                }
                                break block8;
                            }
                            break;
                        }
                    }
                }
                if (boneAnimations.isEmpty() || !(animationLength > 0.0f)) continue;
                baseModel.addAnimation(animationName, new EntityAnimation(animationLength, boneAnimations, loop));
            }
        }

        public static Builder deserialize(JsonObject json, JsonDeserializationContext context) {
            Set jsonEntries = json.get("animations").getAsJsonObject().entrySet();
            HashSet<HashMap<String, Object>> elementsMap = new HashSet<HashMap<String, Object>>(jsonEntries.size());
            for (Map.Entry entry : jsonEntries) {
                String name = (String)entry.getKey();
                JsonObject object = ((JsonElement)entry.getValue()).getAsJsonObject();
                HashMap<String, Object> animationMap = new HashMap<String, Object>();
                if (!object.has("animation_length")) {
                    throw new JsonSyntaxException("Missing animation length property from animation JSON, skipping");
                }
                if (!object.has("bones")) {
                    throw new JsonSyntaxException("Missing bones list from animation JSON, skipping");
                }
                animationMap.put("name", name);
                animationMap.put("animation_length", Float.valueOf(JsonUtils.func_151217_k((JsonObject)object, (String)"animation_length") * 20.0f));
                animationMap.put("bones", object.get("bones").getAsJsonObject().entrySet());
                if (object.has("loop") && object.get("loop").getAsBoolean()) {
                    animationMap.put("loop", true);
                }
                elementsMap.add(animationMap);
            }
            return new Builder(elementsMap);
        }
    }

    private static class BoneAnimation {
        private final ModelRenderer bone;
        private final float[] keyframes;
        private final float[] keyframeRotations;

        private BoneAnimation(ModelRenderer bone, float[] keyFrames, float[] keyframeRotations) {
            this.bone = bone;
            this.keyframes = keyFrames;
            this.keyframeRotations = keyframeRotations;
        }

        protected void rotate(int animationTicks, float partialTicks) {
            for (int i = 0; i < this.keyframes.length; ++i) {
                if (!(this.keyframes[i] >= (float)animationTicks + partialTicks)) continue;
                float framePercentComplete = ((float)animationTicks + partialTicks - this.keyframes[i - 1]) / (this.keyframes[i] - this.keyframes[i - 1]);
                this.bone.field_78795_f = this.keyframeRotations[(i - 1) * 3] + (this.keyframeRotations[i * 3] - this.keyframeRotations[(i - 1) * 3]) * framePercentComplete;
                this.bone.field_78796_g = this.keyframeRotations[(i - 1) * 3 + 1] + (this.keyframeRotations[i * 3 + 1] - this.keyframeRotations[(i - 1) * 3 + 1]) * framePercentComplete;
                this.bone.field_78808_h = this.keyframeRotations[(i - 1) * 3 + 2] + (this.keyframeRotations[i * 3 + 2] - this.keyframeRotations[(i - 1) * 3 + 2]) * framePercentComplete;
                return;
            }
        }
    }
}

