/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.command;

import java.util.Collections;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;

public class CommandAoAEvent
extends CommandBase {
    private static final TextComponentString commandPrefix = new TextComponentString(TextFormatting.DARK_RED + "[AoA" + TextFormatting.GOLD + "Event" + TextFormatting.DARK_RED + "] ");

    public String func_71517_b() {
        return "aoaevent";
    }

    public List<String> func_71514_a() {
        return Collections.singletonList("aoaevents");
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.aoaevent.usage";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.messageSender(sender, Enums.CommandFeedbackType.INFO, "command.aoaevent.desc", new String[0]);
            return;
        }
        switch (args[0]) {
            case "list": {
                this.messageSender(sender, Enums.CommandFeedbackType.INFO, "--", new String[0]);
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaevent.list", new String[0]);
                StringBuilder builder = new StringBuilder();
                for (Enums.CreatureEvents ev : Enums.CreatureEvents.values()) {
                    builder.append(", ");
                    builder.append(ev.toString().toLowerCase());
                }
                sender.func_145747_a(new TextComponentString(builder.toString().substring(2)).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
                break;
            }
            case "check": {
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaevent.check", new String[0]);
                StringBuilder builder = new StringBuilder();
                for (Enums.CreatureEvents ev : Enums.CreatureEvents.values()) {
                    if (!OverworldEvents.isEventActive(ev)) continue;
                    builder.append(", ");
                    builder.append(StringUtil.toTitleCase(ev.name().toLowerCase().replace("_", " ")));
                }
                if (builder.length() == 0) {
                    builder.append("--");
                }
                sender.func_145747_a(new TextComponentString(builder.toString().substring(2)).func_150255_a(new Style().func_150238_a(TextFormatting.GRAY)));
                break;
            }
            case "start": {
                Enums.CreatureEvents event;
                if (args.length < 2) {
                    this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaevent.start.usage", new String[0]);
                    return;
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < args.length; ++i) {
                    builder.append("_");
                    builder.append(args[i]);
                }
                String eventName = builder.toString().substring(1);
                try {
                    event = Enums.CreatureEvents.valueOf(eventName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoaevent.notFound", eventName.toLowerCase());
                    return;
                }
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaevent.starting", StringUtil.toTitleCase(eventName));
                OverworldEvents.activateEvent(sender.func_130014_f_(), event);
                break;
            }
            case "stop": {
                Enums.CreatureEvents event;
                if (args.length < 2) {
                    this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaevent.stop.usage", new String[0]);
                    return;
                }
                StringBuilder builder = new StringBuilder();
                for (int i = 1; i < args.length; ++i) {
                    builder.append("_");
                    builder.append(args[i]);
                }
                String eventName = builder.toString().substring(1);
                try {
                    event = Enums.CreatureEvents.valueOf(eventName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.messageSender(sender, Enums.CommandFeedbackType.ERROR, "command.aoaevent.notFound", eventName.toLowerCase());
                    return;
                }
                this.messageSender(sender, Enums.CommandFeedbackType.SUCCESS, "command.aoaevent.stopping", StringUtil.toTitleCase(eventName));
                OverworldEvents.deactivateEvent(sender.func_130014_f_(), event);
                break;
            }
            default: {
                this.messageSender(sender, Enums.CommandFeedbackType.WARN, "command.aoaevent.usage", new String[0]);
            }
        }
    }

    public int func_82362_a() {
        return 4;
    }

    private void messageSender(ICommandSender sender, Enums.CommandFeedbackType type, String langKey, String ... args) {
        sender.func_145747_a(commandPrefix.func_150259_f().func_150257_a(StringUtil.getLocaleWithArguments(langKey, args).func_150255_a(new Style().func_150238_a(type.getColour()))));
    }
}

