/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.containers;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class ContainerBasicUtility
extends Container {
    public final InventoryBasic inputs;
    public final InventoryCraftResult output;
    private final World world;
    private final BlockPos pos;
    private final EntityPlayer player;

    public ContainerBasicUtility(EntityPlayer player, World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.player = player;
        this.inputs = new InventoryBasic(this.getGuiTitle(), true, 2){

            public void func_70296_d() {
                super.func_70296_d();
                ContainerBasicUtility.this.func_75130_a((IInventory)this);
            }
        };
        this.output = new InventoryCraftResult();
        this.func_75146_a(this.initFirstInputSlot());
        this.func_75146_a(this.initSecondInputSlot());
        this.func_75146_a(this.initOutputSlot());
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, col + row * 9 + 9, 8 + col * 18, 60 + row * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, x, 8 + x * 18, 118));
        }
    }

    public void func_75130_a(IInventory inventory) {
        if (inventory == this.inputs) {
            this.updateOutput();
        }
        super.func_75130_a(inventory);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == 2) {
                if (!this.func_75135_a(slotStack, 3, 39, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slotStack, stack);
            } else if (index != 0 && index != 1 ? index < 39 && !this.func_75135_a(slotStack, 0, 2, false) : !this.func_75135_a(slotStack, 3, 39, false)) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotStack);
        }
        return stack;
    }

    public abstract void updateOutput();

    protected Slot initFirstInputSlot() {
        return new Slot((IInventory)this.inputs, 0, 27, 23);
    }

    protected Slot initSecondInputSlot() {
        return new Slot((IInventory)this.inputs, 1, 76, 23);
    }

    protected abstract Slot initOutputSlot();

    protected abstract String getGuiTitle();

    protected abstract Block getBlock();

    public boolean func_75145_c(EntityPlayer player) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != this.getBlock()) {
            return false;
        }
        return this.player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }
}

