/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.containers;

import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.crafting.recipes.InfusionTableRecipe;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class ContainerInfusionTable
extends Container {
    private InventoryInfusion craftInputs = new InventoryInfusion(this);
    private InventoryCraftResult output = new InventoryCraftResult();
    private final World world;
    private final BlockPos pos;
    private final EntityPlayer player;

    public ContainerInfusionTable(final EntityPlayer player, final World world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.player = player;
        this.func_75146_a(new SlotCraftingMod(player, this.craftInputs, (IInventory)this.output, 0, 139, 35){

            @Override
            protected void func_75208_c(ItemStack stack) {
                InfusionTableRecipe recipe;
                if (!world.field_72995_K && (recipe = (InfusionTableRecipe)((InventoryCraftResult)this.field_75224_c).func_193055_i()) != null && recipe.getMaxXp() > 0) {
                    if (recipe.getMinXp() == recipe.getMaxXp()) {
                        ContainerInfusionTable.this.applyRecipeXp(player, recipe.getMinXp());
                    } else {
                        ContainerInfusionTable.this.applyRecipeXp(player, recipe.getMinXp() + player.func_70681_au().nextInt(recipe.getMaxXp() - recipe.getMinXp()));
                    }
                }
                super.func_75208_c(stack);
            }
        });
        this.func_75146_a(new Slot((IInventory)this.craftInputs, 0, 17, 35));
        for (int matrixY = 0; matrixY < 3; ++matrixY) {
            for (int matrixX = 0; matrixX < 3; ++matrixX) {
                this.func_75146_a(new Slot((IInventory)this.craftInputs, 1 + matrixX + matrixY * 3, 45 + matrixX * 18, 17 + matrixY * 18));
            }
        }
        for (int inventoryY = 0; inventoryY < 3; ++inventoryY) {
            for (int inventoryX = 0; inventoryX < 9; ++inventoryX) {
                this.func_75146_a(new Slot((IInventory)player.field_71071_by, inventoryX + inventoryY * 9 + 9, 8 + inventoryX * 18, 84 + inventoryY * 18));
            }
        }
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)player.field_71071_by, hotbarSlot, 8 + hotbarSlot * 18, 142));
        }
    }

    public void func_75130_a(IInventory inventory) {
        super.func_75130_a(inventory);
        if (inventory == this.craftInputs) {
            this.func_192389_a(this.world, this.player, this.craftInputs, this.output);
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != BlockRegister.infusionTable) {
            return false;
        }
        return player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            this.func_193327_a(player, this.world, (IInventory)this.craftInputs);
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slot) {
        return slot.field_75224_c != this.output && super.func_94530_a(stack, slot);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack stack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            stack = slotStack.func_77946_l();
            if (index == 0) {
                slotStack.func_77973_b().func_77622_d(slotStack, this.world, player);
                if (!this.func_75135_a(slotStack, 11, 47, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 11 && index < 38 ? !this.func_75135_a(slotStack, 38, 47, false) : (index >= 38 && index < 47 ? !this.func_75135_a(slotStack, 11, 38, false) : !this.func_75135_a(slotStack, 11, 47, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == stack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            if (index == 0) {
                player.func_71019_a(slot.func_190901_a(player, slotStack), false);
            }
        }
        return stack;
    }

    protected void func_192389_a(World world, EntityPlayer player, InventoryCrafting inv, InventoryCraftResult craftResult) {
        if (!world.field_72995_K) {
            InfusionTableRecipe matchedRecipe;
            ItemStack resultStack = ItemStack.field_190927_a;
            IRecipe matchingRecipe = CraftingManager.func_192413_b((InventoryCrafting)inv, (World)world);
            if (matchingRecipe instanceof InfusionTableRecipe && ((matchedRecipe = (InfusionTableRecipe)matchingRecipe).func_192399_d() || !world.func_82736_K().func_82766_b("doLimitedCrafting") || ((EntityPlayerMP)player).func_192037_E().func_193830_f((IRecipe)matchedRecipe)) && (player.func_184812_l_() || PlayerUtil.doesPlayerHaveLevel(player, Enums.Skills.INFUSION, matchedRecipe.getInfusionReq()))) {
                craftResult.func_193056_a((IRecipe)matchedRecipe);
                resultStack = matchedRecipe.func_77572_b(inv);
            }
            craftResult.func_70299_a(0, resultStack);
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, resultStack));
        }
    }

    private void applyRecipeXp(EntityPlayer player, float xp) {
        PlayerUtil.giveXpToPlayer(player, Enums.Skills.INFUSION, xp);
    }

    public class SlotCraftingMod
    extends Slot {
        private final InventoryCrafting craftInv;
        private final EntityPlayer player;
        private int amountCrafted;

        public SlotCraftingMod(EntityPlayer pl, InventoryCrafting craftInv, IInventory inv, int slotIndex, int xPos, int yPos) {
            super(inv, slotIndex, xPos, yPos);
            this.player = pl;
            this.craftInv = craftInv;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            if (this.func_75216_d()) {
                this.amountCrafted += Math.min(amount, this.func_75211_c().func_190916_E());
            }
            return super.func_75209_a(amount);
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.amountCrafted += amount;
            this.func_75208_c(stack);
        }

        protected void func_190900_b(int amount) {
            this.amountCrafted += amount;
        }

        protected void func_75208_c(ItemStack stack) {
            if (this.amountCrafted > 0) {
                stack.func_77980_a(this.player.field_70170_p, this.player, this.amountCrafted);
                FMLCommonHandler.instance().firePlayerCraftingEvent(this.player, stack, (IInventory)this.craftInv);
            }
            this.amountCrafted = 0;
            ((InventoryCraftResult)this.field_75224_c).func_193056_a(null);
        }

        public ItemStack func_190901_a(EntityPlayer player, ItemStack stack) {
            this.func_75208_c(stack);
            ForgeHooks.setCraftingPlayer((EntityPlayer)player);
            NonNullList remainingItems = CraftingManager.func_180303_b((InventoryCrafting)this.craftInv, (World)player.field_70170_p);
            ForgeHooks.setCraftingPlayer(null);
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack slotStack = this.craftInv.func_70301_a(i);
                ItemStack remainingItem = (ItemStack)remainingItems.get(i);
                if (!slotStack.func_190926_b()) {
                    this.craftInv.func_70298_a(i, 1);
                    slotStack = this.craftInv.func_70301_a(i);
                }
                if (remainingItem.func_190926_b()) continue;
                if (slotStack.func_190926_b()) {
                    this.craftInv.func_70299_a(i, remainingItem);
                    continue;
                }
                if (ItemStack.func_179545_c((ItemStack)slotStack, (ItemStack)remainingItem) && ItemStack.func_77970_a((ItemStack)slotStack, (ItemStack)remainingItem)) {
                    remainingItem.func_190917_f(slotStack.func_190916_E());
                    this.craftInv.func_70299_a(i, remainingItem);
                    continue;
                }
                if (player.field_71071_by.func_70441_a(remainingItem)) continue;
                player.func_71019_a(remainingItem, false);
            }
            return stack;
        }
    }

    public static class InventoryInfusion
    extends InventoryCrafting {
        private final NonNullList<ItemStack> stackList = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
        private final Container eventListener;

        public InventoryInfusion(Container eventHandler) {
            super(eventHandler, 0, 0);
            this.eventListener = eventHandler;
        }

        public int func_70302_i_() {
            return 10;
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stackList) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index >= this.func_70302_i_() || index < 0 ? ItemStack.field_190927_a : (ItemStack)this.stackList.get(index);
        }

        public ItemStack func_70463_b(int row, int column) {
            return row >= 0 && row < 3 && column >= 0 && column <= 3 ? this.func_70301_a(1 + row + column * 3) : ItemStack.field_190927_a;
        }

        public String func_70005_c_() {
            return "container.aoa3.infusion";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return StringUtil.getLocale(this.func_70005_c_());
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stackList, (int)index);
        }

        public ItemStack func_70298_a(int index, int count) {
            ItemStack stack = ItemStackHelper.func_188382_a(this.stackList, (int)index, (int)count);
            if (!stack.func_190926_b()) {
                this.eventListener.func_75130_a((IInventory)this);
            }
            return stack;
        }

        public void func_70299_a(int index, ItemStack stack) {
            this.stackList.set(index, (Object)stack);
            this.eventListener.func_75130_a((IInventory)this);
        }

        public void func_174888_l() {
            this.stackList.clear();
        }

        public void func_194018_a(RecipeItemHelper recipeItemHelper) {
            for (ItemStack stack : this.stackList) {
                recipeItemHelper.func_194112_a(stack);
            }
        }
    }
}

