/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.packet.PacketPlayerCrownInfo;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.PacketUtil;

public class PlayerCrownHandler {
    private static final HashMap<UUID, PlayerCrownContainer> playerCrowns = new HashMap();
    private static final HashSet<UUID> renderCheckedPlayers = new HashSet();

    public static void syncWithNewClient(EntityPlayerMP player) {
        AdventOfAscension.logOptionalMessage("Syncing player crowns with new player: " + player.func_110124_au().toString());
        PacketUtil.network.sendTo((IMessage)new PacketPlayerCrownInfo(playerCrowns), player);
    }

    public static boolean testForNewRenderer(UUID uuid) {
        return playerCrowns.containsKey(uuid) && renderCheckedPlayers.add(uuid);
    }

    public static void syncNewCrownChoice(UUID uuid, Enums.PlayerCrownTypes crown) {
        if (playerCrowns.containsKey(uuid) && crown != playerCrowns.get(uuid).getPreferredCrown() && (crown = PlayerCrownHandler.testAndCorrectCrownChoice(uuid, crown)) != null) {
            playerCrowns.get(uuid).setPreferredCrown(crown);
            PacketUtil.network.sendToAll((IMessage)new PacketPlayerCrownInfo(uuid, crown));
        }
    }

    public static boolean isDonator(UUID uuid) {
        return PlayerCrownHandler.checkPlayerCrown(uuid, Enums.PlayerCrownTypes.Donator);
    }

    public static boolean isSuperDonator(UUID uuid) {
        return PlayerCrownHandler.checkPlayerCrown(uuid, Enums.PlayerCrownTypes.Super_Donator);
    }

    public static boolean isCrazyDonator(UUID uuid) {
        return PlayerCrownHandler.checkPlayerCrown(uuid, Enums.PlayerCrownTypes.Crazy_Donator);
    }

    public static boolean isWikiEditor(UUID uuid) {
        return PlayerCrownHandler.checkPlayerCrown(uuid, Enums.PlayerCrownTypes.Wiki_Editor);
    }

    public static boolean checkPlayerCrown(UUID uuid, Enums.PlayerCrownTypes crown) {
        PlayerCrownContainer container = playerCrowns.get(uuid);
        return container != null && container.hasCrown(crown);
    }

    @Nullable
    public static HashMap<UUID, PlayerCrownContainer> getCrownMapForPrefill() {
        if (playerCrowns.isEmpty()) {
            return playerCrowns;
        }
        return null;
    }

    public static void updateCrownsMap(HashMap<UUID, PlayerCrownContainer> newMap) {
        Iterator<Map.Entry<UUID, PlayerCrownContainer>> existingMapIterator = playerCrowns.entrySet().iterator();
        while (existingMapIterator.hasNext()) {
            Map.Entry<UUID, PlayerCrownContainer> entry = existingMapIterator.next();
            if (newMap.containsKey(entry.getKey())) {
                entry.setValue(newMap.get(entry.getKey()).setPreferredCrown(entry.getValue().getPreferredCrown()));
                PlayerCrownHandler.testAndCorrectCrownChoice(entry.getKey(), entry.getValue().preferredCrown);
                continue;
            }
            existingMapIterator.remove();
        }
    }

    public static void setCrownChoice(UUID uuid, Enums.PlayerCrownTypes crown) {
        playerCrowns.put(uuid, playerCrowns.getOrDefault(uuid, new PlayerCrownContainer(crown)).setPreferredCrown(crown));
    }

    @Nullable
    public static Enums.PlayerCrownTypes getCrown(UUID uuid) {
        PlayerCrownContainer cont = playerCrowns.get(uuid);
        if (cont != null) {
            return cont.getPreferredCrown();
        }
        return null;
    }

    @Nullable
    private static Enums.PlayerCrownTypes testAndCorrectCrownChoice(UUID uuid, Enums.PlayerCrownTypes preferredCrown) {
        if (PlayerCrownHandler.checkPlayerCrown(uuid, preferredCrown)) {
            return preferredCrown;
        }
        switch (preferredCrown) {
            case Tslat: 
            case Ursun: {
                return null;
            }
            case Wiki_Editor: {
                if (PlayerCrownHandler.isDonator(uuid)) {
                    return Enums.PlayerCrownTypes.Donator;
                }
                if (PlayerCrownHandler.isSuperDonator(uuid)) {
                    return Enums.PlayerCrownTypes.Super_Donator;
                }
                if (!PlayerCrownHandler.isCrazyDonator(uuid)) break;
                return Enums.PlayerCrownTypes.Crazy_Donator;
            }
            case Donator: {
                if (PlayerCrownHandler.isWikiEditor(uuid)) {
                    return Enums.PlayerCrownTypes.Wiki_Editor;
                }
                if (PlayerCrownHandler.isSuperDonator(uuid)) {
                    return Enums.PlayerCrownTypes.Donator;
                }
                if (!PlayerCrownHandler.isCrazyDonator(uuid)) break;
                return Enums.PlayerCrownTypes.Crazy_Donator;
            }
            case Super_Donator: {
                if (PlayerCrownHandler.isWikiEditor(uuid)) {
                    return Enums.PlayerCrownTypes.Wiki_Editor;
                }
                if (PlayerCrownHandler.isDonator(uuid)) {
                    return Enums.PlayerCrownTypes.Donator;
                }
                if (!PlayerCrownHandler.isCrazyDonator(uuid)) break;
                return Enums.PlayerCrownTypes.Crazy_Donator;
            }
            case Crazy_Donator: {
                if (PlayerCrownHandler.isWikiEditor(uuid)) {
                    return Enums.PlayerCrownTypes.Wiki_Editor;
                }
                if (PlayerCrownHandler.isDonator(uuid)) {
                    return Enums.PlayerCrownTypes.Donator;
                }
                if (!PlayerCrownHandler.isSuperDonator(uuid)) break;
                return Enums.PlayerCrownTypes.Super_Donator;
            }
        }
        return null;
    }

    public static class PlayerCrownContainer {
        private Enums.PlayerCrownTypes preferredCrown;
        private final HashSet<Enums.PlayerCrownTypes> unlockedCrowns;

        public PlayerCrownContainer(HashSet<Enums.PlayerCrownTypes> availableCrowns) {
            this.unlockedCrowns = availableCrowns;
            this.preferredCrown = availableCrowns.iterator().next();
        }

        public PlayerCrownContainer(Enums.PlayerCrownTypes preferredCrown) {
            this.preferredCrown = preferredCrown;
            this.unlockedCrowns = null;
        }

        PlayerCrownContainer setPreferredCrown(Enums.PlayerCrownTypes crown) {
            if (this.unlockedCrowns == null || this.unlockedCrowns.contains((Object)this.preferredCrown)) {
                this.preferredCrown = crown;
            }
            return this;
        }

        public Enums.PlayerCrownTypes getPreferredCrown() {
            return this.preferredCrown;
        }

        public boolean hasCrown(Enums.PlayerCrownTypes crown) {
            return this.unlockedCrowns.contains((Object)crown);
        }
    }
}

