/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.common.packet.leaderboard;

import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.leaderboard.Leaderboard;
import net.tslat.aoa3.utils.ConfigurationUtil;
import org.apache.logging.log4j.Level;

public class PacketLeaderboardStats
implements IMessage {
    public int skillId;
    public int firstRank;
    public int byteArraySize;
    public ArrayList<Leaderboard.TrimmedLeaderboardEntry> entries;

    public PacketLeaderboardStats() {
    }

    public PacketLeaderboardStats(@Nullable Enums.Skills skill, int topRank, ArrayList<Leaderboard.TrimmedLeaderboardEntry> entries) {
        this.skillId = skill == null ? -1 : skill.id;
        this.firstRank = topRank;
        this.entries = entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fromBytes(ByteBuf buffer) {
        this.skillId = buffer.readInt();
        this.firstRank = buffer.readInt();
        this.byteArraySize = buffer.readInt();
        byte[] byteArray = new byte[this.byteArraySize];
        buffer.readBytes(new byte[buffer.readableBytes()]);
        ByteArrayInputStream arrayStreamIn = new ByteArrayInputStream(byteArray);
        ObjectInputStream objectIn = null;
        ArrayList readEntries = null;
        try {
            objectIn = new ObjectInputStream(arrayStreamIn);
            readEntries = (ArrayList)objectIn.readObject();
        }
        catch (Exception e) {
            if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
                AdventOfAscension.logMessage(Level.WARN, "Unable to deserialize packet for leaderboard stats, skipping");
            }
        }
        finally {
            this.entries = readEntries;
            try {
                arrayStreamIn.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void toBytes(ByteBuf buffer) {
        block14: {
            ByteArrayOutputStream byteStreamOut;
            byte[] entriesByteArray;
            block12: {
                buffer.writeInt(this.skillId);
                buffer.writeInt(this.firstRank);
                entriesByteArray = null;
                byteStreamOut = new ByteArrayOutputStream();
                ObjectOutputStream objectOut = null;
                objectOut = new ObjectOutputStream(byteStreamOut);
                objectOut.writeObject(this.entries);
                objectOut.flush();
                entriesByteArray = byteStreamOut.toByteArray();
                if (entriesByteArray == null) break block12;
                buffer.writeInt(entriesByteArray.length);
                buffer.writeBytes(entriesByteArray);
            }
            try {
                byteStreamOut.close();
            }
            catch (Exception exception) {}
            break block14;
            catch (Exception e) {
                block13: {
                    try {
                        if (ConfigurationUtil.MainConfig.doVerboseDebugging) {
                            AdventOfAscension.logMessage(Level.WARN, "Failed to serialize packet for leaderboard stats, skipping");
                        }
                        if (entriesByteArray == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (entriesByteArray != null) {
                            buffer.writeInt(entriesByteArray.length);
                            buffer.writeBytes(entriesByteArray);
                        }
                        try {
                            byteStreamOut.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    buffer.writeInt(entriesByteArray.length);
                    buffer.writeBytes(entriesByteArray);
                }
                try {
                    byteStreamOut.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public static class Handler
    implements IMessageHandler<PacketLeaderboardStats, IMessage> {
        public IMessage onMessage(PacketLeaderboardStats msg, MessageContext ctx) {
            AdventOfAscension.proxy.handleLeaderboardData(msg);
            return null;
        }
    }
}

