/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.crafting.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tslat.aoa3.common.containers.ContainerInfusionTable;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class InfusionTableRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final ItemStack output;
    private final ItemStack input;
    protected final NonNullList<Ingredient> ingredients;
    private final String group;
    private final boolean isSimple;
    private final int minXp;
    private final int maxXp;
    private final boolean isEnchanting;
    private final Enchantment enchantment;
    private final int enchantmentLevel;
    private final int infusionReq;

    public InfusionTableRecipe(String group, ItemStack output, ItemStack input, NonNullList<Ingredient> ingredients, int infusionLevelReq, int minXp, int maxXp) {
        this.isEnchanting = false;
        this.output = output;
        this.input = input;
        this.ingredients = ingredients;
        this.group = group;
        this.infusionReq = infusionLevelReq;
        boolean simple = true;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isSimple()) continue;
            simple = false;
            break;
        }
        this.isSimple = simple;
        this.enchantment = null;
        this.enchantmentLevel = -1;
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public InfusionTableRecipe(String group, Enchantment enchantment, int level, NonNullList<Ingredient> ingredients, int infusionLevelReq, int minXp, int maxXp) {
        this.isEnchanting = true;
        this.group = group;
        this.enchantment = enchantment;
        this.ingredients = ingredients;
        this.enchantmentLevel = level;
        this.infusionReq = infusionLevelReq;
        boolean simple = true;
        for (Ingredient ingredient : ingredients) {
            if (ingredient.isSimple()) continue;
            simple = false;
            break;
        }
        this.isSimple = simple;
        this.output = ItemStack.field_190927_a;
        this.input = ItemStack.field_190927_a;
        this.minXp = minXp;
        this.maxXp = maxXp;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (inv instanceof ContainerInfusionTable.InventoryInfusion) {
            int ingredientCount = 0;
            RecipeItemHelper recipeItemHelper = new RecipeItemHelper();
            ArrayList<ItemStack> inputIngredients = new ArrayList<ItemStack>();
            ItemStack inputStack = inv.func_70301_a(0);
            if (inputStack.func_190926_b() || !this.isEnchanting && (this.input.func_77973_b() != inputStack.func_77973_b() || this.input.func_77960_j() != Short.MAX_VALUE && this.input.func_77960_j() != inputStack.func_77960_j())) {
                return false;
            }
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                ++ingredientCount;
                if (this.isSimple) {
                    recipeItemHelper.accountStack(stack, 1);
                    continue;
                }
                inputIngredients.add(stack);
            }
            if (ingredientCount != this.ingredients.size()) {
                return false;
            }
            if (this.isEnchanting && EnchantmentHelper.func_77506_a((Enchantment)this.enchantment, (ItemStack)inputStack) >= this.enchantmentLevel) {
                return false;
            }
            if (this.isSimple) {
                return recipeItemHelper.func_194116_a((IRecipe)this, null);
            }
            return RecipeMatcher.findMatches(inputIngredients, this.ingredients) != null;
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        if (this.isEnchanting) {
            return this.provideEmptyOrCompatibleStackForEnchanting(inv.func_70301_a(0).func_77946_l());
        }
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public ItemStack func_77571_b() {
        return this.isEnchanting ? ItemStack.field_190927_a : this.output;
    }

    public ItemStack getRecipeInput() {
        return this.input;
    }

    public boolean isEnchanting() {
        return this.isEnchanting;
    }

    public int getInfusionReq() {
        return this.infusionReq;
    }

    public int getMinXp() {
        return this.minXp;
    }

    public int getMaxXp() {
        return this.maxXp;
    }

    public ItemStack getEnchantmentAsBook() {
        if (!this.isEnchanting) {
            return ItemStack.field_190927_a;
        }
        ItemStack bookStack = new ItemStack(Items.field_151134_bR);
        ItemEnchantedBook.func_92115_a((ItemStack)bookStack, (EnchantmentData)new EnchantmentData(this.enchantment, this.enchantmentLevel));
        return bookStack;
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return this.ingredients;
    }

    public String func_193358_e() {
        return this.group;
    }

    public boolean containsIngredient(ItemStack item) {
        for (Ingredient ing : this.ingredients) {
            if (!ing.apply(item)) continue;
            return true;
        }
        return false;
    }

    public ItemStack provideEmptyOrCompatibleStackForEnchanting(ItemStack inputStack) {
        if (!this.enchantment.func_92089_a(inputStack) || !ConfigurationUtil.MainConfig.allowUnsafeInfusion && this.enchantment.func_77325_b() < this.enchantmentLevel) {
            return ItemStack.field_190927_a;
        }
        Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)inputStack);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (this.enchantment == enchantment || enchantment.func_191560_c(this.enchantment) && this.enchantment.func_191560_c(enchantment)) continue;
            return ItemStack.field_190927_a;
        }
        enchantments.put(this.enchantment, this.enchantmentLevel);
        EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)inputStack);
        return inputStack;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            if (JsonUtils.func_151204_g((JsonObject)json, (String)"infusion")) {
                String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
                int level = 0;
                int infusionReq = 1;
                int minXp = 0;
                int maxXp = 0;
                NonNullList ingredients = NonNullList.func_191196_a();
                JsonObject enchantmentJson = JsonUtils.func_152754_s((JsonObject)json, (String)"infusion");
                if (!enchantmentJson.has("enchantment")) {
                    throw new JsonParseException("No valid enchantment for Infusion recipe");
                }
                String enchantmentString = JsonUtils.func_151200_h((JsonObject)enchantmentJson, (String)"enchantment");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(enchantmentString));
                if (json.has("infusion_level")) {
                    infusionReq = JsonUtils.func_151203_m((JsonObject)json, (String)"infusion_level");
                }
                if (json.has("infusion_xp")) {
                    JsonObject xpJson = JsonUtils.func_152754_s((JsonObject)json, (String)"infusion_xp");
                    if (xpJson.isJsonPrimitive()) {
                        minXp = maxXp = xpJson.getAsInt();
                    } else if (xpJson.has("min")) {
                        if (!xpJson.has("max")) {
                            throw new JsonParseException("No max set for min/max xp amount for infusion recipe");
                        }
                        minXp = Math.max(0, JsonUtils.func_151203_m((JsonObject)xpJson, (String)"min"));
                        maxXp = Math.max(minXp, JsonUtils.func_151203_m((JsonObject)xpJson, (String)"max"));
                    }
                }
                if (enchantment == null) {
                    throw new JsonParseException("Invalid enchantment for infusion recipe: " + enchantmentString);
                }
                if (enchantmentJson.has("level")) {
                    level = JsonUtils.func_151203_m((JsonObject)enchantmentJson, (String)"level");
                }
                if (!ConfigurationUtil.MainConfig.allowUnsafeInfusion && enchantment.func_77325_b() < level) {
                    throw new JsonParseException("Unsafe enchantment level for recipe, Enchantment: " + I18n.func_74838_a((String)enchantment.func_77320_a()) + ", Lvl: " + level + ", and Allow Unsafe Infusion not enabled in config");
                }
                for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                    ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
                }
                if (ingredients.isEmpty()) {
                    throw new JsonParseException("No ingredients for infusion table recipe");
                }
                if (ingredients.size() > 9) {
                    throw new JsonParseException("Too many ingredients for infusion table recipe");
                }
                return new InfusionTableRecipe(group, enchantment, level, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
            }
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack input = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"input"), (JsonContext)context);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            NonNullList ingredients = NonNullList.func_191196_a();
            int infusionReq = 1;
            int minXp = 0;
            int maxXp = 0;
            if (json.has("infusion_level")) {
                infusionReq = JsonUtils.func_151203_m((JsonObject)json, (String)"infusion_level");
            }
            if (json.has("infusion_xp")) {
                JsonObject xpJson = JsonUtils.func_152754_s((JsonObject)json, (String)"infusion_xp");
                if (xpJson.isJsonPrimitive()) {
                    minXp = maxXp = xpJson.getAsInt();
                } else if (xpJson.has("min")) {
                    if (!xpJson.has("max")) {
                        throw new JsonParseException("No max set for min/max xp amount for infusion recipe");
                    }
                    minXp = Math.max(0, JsonUtils.func_151203_m((JsonObject)xpJson, (String)"min"));
                    maxXp = Math.max(minXp, JsonUtils.func_151203_m((JsonObject)xpJson, (String)"max"));
                }
            }
            for (JsonElement element : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
                ingredients.add((Object)CraftingHelper.getIngredient((JsonElement)element, (JsonContext)context));
            }
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for infusion table recipe");
            }
            if (ingredients.size() > 9) {
                throw new JsonParseException("Too many ingredients for infusion table recipe");
            }
            return new InfusionTableRecipe(group, output, input, (NonNullList<Ingredient>)ingredients, infusionReq, minXp, maxXp);
        }
    }
}

