/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.crafting.recipes;

import com.google.gson.JsonObject;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.tslat.aoa3.common.containers.ContainerDivineStation;

public class UpgradeKitRecipe
extends IForgeRegistryEntry.Impl<IRecipe>
implements IRecipe {
    private final String group;
    private final ItemStack input;
    private final ItemStack upgradeKit;
    private final ItemStack output;

    public UpgradeKitRecipe(String group, ItemStack input, ItemStack upgradeKit, ItemStack output) {
        this.group = group;
        this.input = input;
        this.upgradeKit = upgradeKit;
        this.output = output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        if (inv instanceof ContainerDivineStation.InventoryDivineStation) {
            return ItemStack.func_179545_c((ItemStack)this.input, (ItemStack)inv.func_70301_a(0)) && ItemStack.func_179545_c((ItemStack)this.upgradeKit, (ItemStack)inv.func_70301_a(1));
        }
        return false;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.output.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= 3;
    }

    public ItemStack func_77571_b() {
        return this.output.func_77946_l();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList remainingItems = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)stack));
        }
        return remainingItems;
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ingredients = NonNullList.func_191196_a();
        ingredients.add((Object)CraftingHelper.getIngredient((Object)this.input));
        ingredients.add((Object)CraftingHelper.getIngredient((Object)this.upgradeKit));
        return ingredients;
    }

    public String func_193358_e() {
        return this.group;
    }

    public static class Factory
    implements IRecipeFactory {
        public IRecipe parse(JsonContext context, JsonObject json) {
            String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
            ItemStack inputItem = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"input"), (JsonContext)context);
            ItemStack upgradeKit = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"upgrade_kit"), (JsonContext)context);
            ItemStack output = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
            return new UpgradeKitRecipe(group, inputItem, upgradeKit, output);
        }
    }
}

