/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.abyss.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeAbyss
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Abyssal Wastelands");

    public BiomeAbyss() {
        super(properties);
        this.setRegistryName("aoa3", "abyss");
        this.field_76752_A = BlockRegister.getUnmappedBlock("abyss_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("abyss_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeAbyssDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPOOKY});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.RED.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.0f);
        properties.func_185395_b(100.0f);
        properties.func_185402_a(Color.RED.getRGB());
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.4f);
    }

    public class BiomeAbyssDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < ConfigurationUtil.OreConfig.bloodstone.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreBloodstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.bloodstone.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.bloodstone.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneAbyss)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(5) + 45, rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < 20; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                world.func_175656_a((BlockPos)pos.func_181079_c(posX, posY, posZ), BlockRegister.plantTubeicles.func_176223_P());
            }
            block6: for (i = 0; i < 4; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                switch (rand.nextInt(5)) {
                    case 0: 
                    case 1: {
                        StructuresHandler.generateStructure("BloodPine", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block6;
                    }
                    case 2: 
                    case 3: {
                        StructuresHandler.generateStructure("EyeShrub", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block6;
                    }
                    case 4: {
                        StructuresHandler.generateStructure("BloodSpikes", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block13: for (int i = 0; i < 2; ++i) {
                switch (rand.nextInt(11)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 2, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 1)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree5", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 5: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ + 1)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree6", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 6: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX, posZ);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY - 1, posZ)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("TentacleTree7", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 7: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 3, posZ + 3);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("AbyssalTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 8: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 5, posZ + 5);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 5, posY - 1, posZ + 5)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("AbyssalTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 9: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 3, posZ + 3);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("AbyssalTree3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block13;
                    }
                    case 10: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 3, posZ + 3);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A) continue block13;
                        StructuresHandler.generateStructure("AbyssalTree4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

