/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.lborean.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;

public class BiomeLBorean
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("L'Borean Ponds");

    public BiomeLBorean() {
        super(properties);
        this.setRegistryName("aoa3", "lborean");
        this.field_76752_A = BlockRegister.getUnmappedBlock("borean_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("borean_dirt").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeLBoreanDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.WET, BiomeDictionary.Type.WATER});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.BLUE.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.5f);
        properties.func_185395_b(500.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.05f);
    }

    public class BiomeLBoreanDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block7: for (int i = 0; i < 65; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p(pos.func_181079_c(posX, posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16)), posZ).func_177977_b()) != biome.field_76752_A) continue;
                if (rand.nextInt(6500) == 0) {
                    world.func_175656_a((BlockPos)pos, BlockRegister.plantWaterweedsRed.func_176223_P());
                    continue;
                }
                switch (rand.nextInt(5)) {
                    case 0: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantBurealStocks.func_176223_P());
                        continue block7;
                    }
                    case 1: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantWaterweedsGreen.func_176223_P());
                        continue block7;
                    }
                    case 2: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantWaterweedsWhite.func_176223_P());
                        continue block7;
                    }
                    case 3: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantWaterweedsYellow.func_176223_P());
                        continue block7;
                    }
                    case 4: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantOcealitesBlue.func_176223_P());
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            posX = basePos.func_177958_n() + rand.nextInt(16);
            posZ = basePos.func_177952_p() + rand.nextInt(16);
            switch (rand.nextInt(6)) {
                case 0: {
                    posY = world.func_189649_b(posX + 3, posZ + 3);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("GreenCoral1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 1: {
                    posY = world.func_189649_b(posX + 1, posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 10)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("GreenCoral2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 2: {
                    posY = world.func_189649_b(posX + 4, posZ + 4);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("PinkCoral1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 3: {
                    posY = world.func_189649_b(posX + 1, posZ + 1);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 10, posY - 1, posZ + 1)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("OrangeCoral", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 4: {
                    posY = world.func_189649_b(posX + 4, posZ + 4);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("WhiteCoral", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    break;
                }
                case 5: {
                    posY = world.func_189649_b(posX + 4, posZ + 5);
                    if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 5)) != biome.field_76752_A) break;
                    StructuresHandler.generateStructure("YellowCoral", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                }
            }
        }
    }
}

