/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.lelyetia;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.FloatingDimChunk;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenLelyetia
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private final Biome biome = BiomeRegister.biomeLelyetia;
    private int x;
    private int y;
    private int z;

    protected ChunkGenLelyetia(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        this.setBlocksInChunk();
        FloatingDimChunk chunk = new FloatingDimChunk(this.world, this.primer, chunkX, chunkZ);
        Arrays.fill(chunk.func_76605_m(), (byte)Biome.func_185362_a((Biome)this.biome));
        chunk.func_76603_b();
        return chunk;
    }

    private void setBlocksInChunk() {
        if (this.rand.nextInt(11) > 7) {
            switch (this.rand.nextInt(7)) {
                case 0: {
                    this.genLandStrip(0, 55, 0, 15, 59, 0);
                    this.genLandStrip(0, 55, 15, 15, 59, 15);
                    this.genLandStrip(15, 55, 0, 15, 59, 15);
                    this.genLandStrip(0, 55, 0, 0, 59, 15);
                    this.primer.func_177855_a(1, 59, 1, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(14, 59, 14, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(1, 59, 14, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(14, 59, 1, BlockRegister.grassLelyetia.func_176223_P());
                    this.genLandStrip(1, 55, 1, 14, 58, 1);
                    this.genLandStrip(1, 55, 14, 14, 58, 14);
                    this.genLandStrip(14, 55, 1, 14, 58, 14);
                    this.genLandStrip(1, 55, 1, 1, 58, 14);
                    this.primer.func_177855_a(2, 58, 2, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(13, 58, 13, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(2, 58, 13, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(13, 58, 2, BlockRegister.grassLelyetia.func_176223_P());
                    this.genLandStrip(2, 55, 2, 13, 57, 2);
                    this.genLandStrip(2, 55, 13, 13, 57, 13);
                    this.genLandStrip(13, 55, 2, 13, 57, 13);
                    this.genLandStrip(2, 55, 2, 2, 57, 13);
                    this.primer.func_177855_a(3, 57, 3, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(12, 57, 12, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(3, 57, 12, BlockRegister.grassLelyetia.func_176223_P());
                    this.primer.func_177855_a(12, 57, 3, BlockRegister.grassLelyetia.func_176223_P());
                    this.genLandStrip(3, 55, 3, 12, 56, 3);
                    this.genLandStrip(3, 55, 12, 12, 56, 12);
                    this.genLandStrip(12, 55, 3, 12, 56, 12);
                    this.genLandStrip(3, 55, 3, 3, 56, 12);
                    break;
                }
                case 1: {
                    this.genLandStrip(0, 55, 0, 15, 59, 1);
                    this.genLandStrip(0, 55, 14, 15, 59, 15);
                    this.genLandStrip(0, 55, 2, 1, 59, 13);
                    this.genLandStrip(14, 55, 2, 15, 59, 13);
                    this.genLandStrip(4, 55, 4, 11, 59, 5);
                    this.genLandStrip(4, 55, 10, 11, 59, 11);
                    this.genLandStrip(4, 55, 6, 5, 59, 9);
                    this.genLandStrip(10, 55, 6, 11, 59, 9);
                    break;
                }
                case 2: {
                    this.genLandStrip(0, 55, 0, 15, 59, 0);
                    this.genLandStrip(0, 55, 15, 15, 59, 15);
                    this.genLandStrip(15, 55, 0, 15, 59, 15);
                    this.genLandStrip(0, 55, 0, 0, 59, 15);
                    this.genLandStrip(1, 55, 1, 6, 59, 6);
                    this.genLandStrip(9, 55, 1, 14, 59, 6);
                    this.genLandStrip(1, 55, 9, 6, 59, 14);
                    this.genLandStrip(9, 55, 9, 14, 59, 14);
                    break;
                }
                case 3: {
                    this.genLandStrip(0, 55, 0, 15, 59, 1);
                    this.genLandStrip(0, 55, 14, 15, 59, 15);
                    this.genLandStrip(0, 55, 2, 1, 59, 13);
                    this.genLandStrip(14, 55, 2, 15, 59, 13);
                    this.genLandStrip(2, 55, 2, 13, 57, 3);
                    this.genLandStrip(2, 55, 12, 13, 57, 13);
                    this.genLandStrip(2, 55, 2, 3, 57, 11);
                    this.genLandStrip(12, 55, 2, 13, 57, 11);
                    this.genLandStrip(4, 55, 4, 11, 56, 5);
                    this.genLandStrip(4, 55, 10, 11, 56, 11);
                    this.genLandStrip(4, 55, 4, 5, 56, 9);
                    this.genLandStrip(10, 55, 4, 11, 56, 9);
                    break;
                }
                case 4: {
                    this.genLandStrip(0, 55, 0, 15, 59, 4);
                    this.genLandStrip(0, 55, 11, 15, 59, 15);
                    this.genLandStrip(0, 55, 5, 4, 59, 10);
                    this.genLandStrip(11, 55, 5, 15, 59, 10);
                    this.genLandStrip(5, 55, 10, 6, 59, 10);
                    this.genLandStrip(5, 55, 9, 5, 59, 9);
                    this.genLandStrip(9, 55, 10, 10, 59, 10);
                    this.genLandStrip(10, 55, 9, 10, 59, 9);
                    this.genLandStrip(5, 55, 5, 5, 59, 6);
                    this.genLandStrip(6, 55, 5, 6, 59, 5);
                    this.genLandStrip(10, 55, 5, 10, 59, 6);
                    this.genLandStrip(9, 55, 5, 9, 59, 5);
                    break;
                }
                case 5: {
                    this.genLandStrip(0, 55, 0, 15, 59, 1);
                    this.genLandStrip(0, 55, 14, 15, 59, 15);
                    this.genLandStrip(0, 55, 2, 1, 59, 13);
                    this.genLandStrip(14, 55, 2, 15, 59, 13);
                    this.setAllBlocksInRegion(7, 58, 2, 8, 58, 13, BlockRegister.stoneLelyetia.func_176223_P());
                    this.setAllBlocksInRegion(2, 58, 7, 6, 58, 8, BlockRegister.stoneLelyetia.func_176223_P());
                    this.setAllBlocksInRegion(9, 58, 7, 13, 58, 8, BlockRegister.stoneLelyetia.func_176223_P());
                    this.setAllBlocksInRegion(7, 59, 2, 8, 59, 13, BlockRegister.grassLelyetia.func_176223_P());
                    this.setAllBlocksInRegion(2, 59, 7, 6, 59, 8, BlockRegister.grassLelyetia.func_176223_P());
                    this.setAllBlocksInRegion(9, 59, 7, 13, 59, 8, BlockRegister.grassLelyetia.func_176223_P());
                    break;
                }
                case 6: {
                    this.genLandStrip(0, 55, 0, 15, 59, 0);
                    this.genLandStrip(0, 55, 15, 15, 59, 15);
                    this.genLandStrip(15, 55, 0, 15, 59, 15);
                    this.genLandStrip(0, 55, 0, 0, 59, 15);
                    this.genLandStrip(7, 55, 1, 8, 59, 14);
                    this.genLandStrip(1, 55, 7, 6, 59, 8);
                    this.genLandStrip(9, 55, 7, 14, 59, 8);
                    this.genLandStrip(1, 55, 1, 6, 58, 1);
                    this.genLandStrip(1, 55, 6, 6, 58, 6);
                    this.genLandStrip(1, 55, 2, 1, 58, 5);
                    this.genLandStrip(6, 55, 2, 6, 58, 5);
                    this.genLandStrip(2, 55, 2, 5, 57, 2);
                    this.genLandStrip(2, 55, 5, 5, 57, 5);
                    this.genLandStrip(2, 55, 3, 2, 57, 4);
                    this.genLandStrip(5, 55, 3, 5, 57, 4);
                    this.genLandStrip(1, 55, 9, 6, 58, 9);
                    this.genLandStrip(1, 55, 14, 6, 58, 14);
                    this.genLandStrip(1, 55, 10, 1, 58, 13);
                    this.genLandStrip(6, 55, 10, 6, 58, 13);
                    this.genLandStrip(2, 55, 10, 5, 57, 10);
                    this.genLandStrip(2, 55, 13, 5, 57, 13);
                    this.genLandStrip(2, 55, 11, 2, 57, 12);
                    this.genLandStrip(5, 55, 11, 5, 57, 12);
                    this.genLandStrip(9, 55, 1, 14, 58, 1);
                    this.genLandStrip(9, 55, 6, 14, 58, 6);
                    this.genLandStrip(9, 55, 2, 9, 58, 5);
                    this.genLandStrip(14, 55, 2, 14, 58, 5);
                    this.genLandStrip(10, 55, 2, 13, 57, 2);
                    this.genLandStrip(10, 55, 5, 13, 57, 5);
                    this.genLandStrip(10, 55, 3, 10, 57, 4);
                    this.genLandStrip(13, 55, 3, 13, 57, 4);
                    this.genLandStrip(9, 55, 9, 14, 58, 9);
                    this.genLandStrip(9, 55, 14, 14, 58, 14);
                    this.genLandStrip(9, 55, 10, 9, 58, 13);
                    this.genLandStrip(14, 55, 10, 14, 58, 13);
                    this.genLandStrip(10, 55, 10, 13, 57, 10);
                    this.genLandStrip(10, 55, 13, 13, 57, 13);
                    this.genLandStrip(10, 55, 11, 10, 57, 12);
                    this.genLandStrip(13, 55, 11, 13, 57, 12);
                }
            }
        } else {
            this.genLandStrip(0, 55, 0, 15, 59, 15);
        }
    }

    private void genLandStrip(int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ) {
        this.setAllBlocksInRegion(lowerX, lowerY, lowerZ, upperX, lowerY, upperZ, BlockRegister.grassLelyetiaDown.func_176223_P());
        this.setAllBlocksInRegion(lowerX, lowerY + 1, lowerZ, upperX, upperY - 1, upperZ, BlockRegister.stoneLelyetia.func_176223_P());
        this.setAllBlocksInRegion(lowerX, upperY, lowerZ, upperX, upperY, upperZ, BlockRegister.grassLelyetia.func_176223_P());
    }

    private void setAllBlocksInRegion(int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, IBlockState block) {
        this.x = lowerX;
        while (this.x <= upperX) {
            this.y = lowerY;
            while (this.y <= upperY) {
                this.z = lowerZ;
                while (this.z <= upperZ) {
                    this.primer.func_177855_a(this.x, this.y, this.z, block);
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int z;
        int y;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (ConfigurationUtil.StructureConfig.lelyetia.lelyetianTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lelyetia.lelyetianTowerSpawnChance) == 0) {
            int z2;
            int y2;
            int x2 = baseX + this.rand.nextInt(16);
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 7, (y2 = 60) - 1, (z2 = baseZ + this.rand.nextInt(16)) + 7)) == biome.field_76752_A && this.world.func_180495_p((BlockPos)pos.func_181079_c(x2 + 7, y2, z2 + 7)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("LelyetianTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x2, y2, z2));
            }
        } else if (ConfigurationUtil.StructureConfig.lelyetia.zhinxEnclaveSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lelyetia.zhinxEnclaveSpawnChance) == 0) {
            int x3 = baseX + this.rand.nextInt(16);
            int z3 = baseZ + this.rand.nextInt(16);
            int y3 = 15;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x3 + 4, 55, z3 + 6)).func_177230_c() != Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ZhinxEnclave", this.world, this.rand, (BlockPos)pos.func_181079_c(x3, y3, z3));
            }
        } else if (ConfigurationUtil.StructureConfig.lelyetia.paraviteHiveSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lelyetia.paraviteHiveSpawnChance) == 0) {
            int x4 = baseX + this.rand.nextInt(16);
            int z4 = baseZ + this.rand.nextInt(16);
            int y4 = 36;
            if (this.world.func_180495_p((BlockPos)pos.func_181079_c(x4 + 6, 55, z4 + 6)).func_177230_c() != Blocks.field_150350_a) {
                StructuresHandler.generateStructure("ParaviteHive", this.world, this.rand, (BlockPos)pos.func_181079_c(x4, y4, z4));
            }
        } else if (ConfigurationUtil.StructureConfig.lelyetia.boneyDungeonSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lelyetia.boneyDungeonSpawnChance) == 0) {
            int x5 = baseX + this.rand.nextInt(16);
            int z5 = baseZ + this.rand.nextInt(16);
            int y5 = 31;
            StructuresHandler.generateStructure("BoneyDungeon", this.world, this.rand, (BlockPos)pos.func_181079_c(x5, y5, z5));
        } else if (ConfigurationUtil.StructureConfig.lelyetia.grawPillarSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.lelyetia.grawPillarSpawnChance) == 0 && this.world.func_180495_p((BlockPos)pos.func_181079_c((x = baseX + this.rand.nextInt(16)) + 2, (y = 60) - 1, (z = baseZ + this.rand.nextInt(16)) + 2)) == biome.field_76752_A && this.world.func_180495_p((BlockPos)pos.func_181079_c(x + 2, y, z + 2)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("GrawPillar", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(baseX + 8), (int)(baseZ + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

