/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.nether;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class NetherGen {
    public static void generate(World world, Random random, int chunkX, int chunkZ, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        NetherGen.doOreGen(world, random, chunkX * 16, chunkZ * 16);
        NetherGen.doStructureGen(world, random, chunkX * 16 + 1, chunkZ * 16 + 1);
    }

    private static void doOreGen(World world, Random rand, int chunkX, int chunkZ) {
        for (int i = 0; i < ConfigurationUtil.OreConfig.emberstone.veinsPerChunk; ++i) {
            int posX = chunkX + rand.nextInt(16);
            int posY = 5 + rand.nextInt(120);
            int posZ = chunkZ + rand.nextInt(16);
            new WorldGenMinable(BlockRegister.oreEmberstone.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.emberstone.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.emberstone.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)Blocks.field_150424_aL)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
        }
    }

    private static void doStructureGen(World world, Random rand, int baseX, int baseZ) {
        int posY;
        int posZ;
        int posX;
        if (ConfigurationUtil.StructureConfig.nether.nethengeicPitSpawnChance > 0 && rand.nextInt(ConfigurationUtil.StructureConfig.nether.nethengeicPitSpawnChance) == 0) {
            posX = baseX + rand.nextInt(14);
            posZ = baseZ + rand.nextInt(14);
            posY = rand.nextInt(35) + 25;
            if (world.func_180495_p(new BlockPos(posX, posY - 1, posZ)).func_177230_c() == Blocks.field_150424_aL) {
                StructuresHandler.generateStructure("NethengeicPit", world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.StructureConfig.nether.fireRuneShrineSpawnChance > 0 && rand.nextInt(ConfigurationUtil.StructureConfig.nether.fireRuneShrineSpawnChance) == 0) {
            posX = baseX + rand.nextInt(16);
            posZ = baseZ + rand.nextInt(16);
            posY = rand.nextInt(50) + 10;
            if (world.func_180495_p(new BlockPos(posX, posY, posZ)).func_177230_c() == Blocks.field_150350_a) {
                StructuresHandler.generateStructure("FireRuneShrine", world, rand, new BlockPos(posX, posY, posZ));
            }
        }
    }
}

