/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.overworld;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class OverworldGen {
    public static void generate(World world, Random random, int chunkX, int chunkZ, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        OverworldGen.doOreGen(world, random, chunkX * 16, chunkZ * 16);
        OverworldGen.doStructureGen(world, random, chunkX * 16 + 1, chunkZ * 16 + 1);
    }

    private static void doOreGen(World world, Random rand, int chunkX, int chunkZ) {
        int posZ;
        int posY;
        int posX;
        int i;
        if (ConfigurationUtil.OreConfig.amethyst.maxVeinsPerChunk > 0) {
            for (i = 0; i < rand.nextInt(ConfigurationUtil.OreConfig.amethyst.maxVeinsPerChunk); ++i) {
                posX = chunkX + rand.nextInt(16);
                posY = 14 + rand.nextInt(17);
                posZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(BlockRegister.oreAmethyst.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.amethyst.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.amethyst.maxOresPerVein) + 1)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.OreConfig.rosite.maxVeinsPerChunk > 0) {
            for (i = 0; i < rand.nextInt(ConfigurationUtil.OreConfig.rosite.maxVeinsPerChunk); ++i) {
                posX = chunkX + rand.nextInt(16);
                posY = 17 + rand.nextInt(31);
                posZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(BlockRegister.oreRosite.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.rosite.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.rosite.maxOresPerVein) + 1)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.OreConfig.limonite.maxVeinsPerChunk > 0) {
            for (i = 0; i < rand.nextInt(ConfigurationUtil.OreConfig.limonite.maxVeinsPerChunk); ++i) {
                posX = chunkX + rand.nextInt(16);
                posY = 8 + rand.nextInt(60);
                posZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(BlockRegister.oreLimonite.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.limonite.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.limonite.maxOresPerVein) + 1)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.OreConfig.runium.maxVeinsPerChunk > 0) {
            for (i = 0; i < rand.nextInt(ConfigurationUtil.OreConfig.runium.maxVeinsPerChunk); ++i) {
                posX = chunkX + rand.nextInt(16);
                posY = 5 + rand.nextInt(128);
                posZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(BlockRegister.oreRunium.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.runium.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.runium.maxOresPerVein) + 1)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.OreConfig.jade.maxVeinsPerChunk > 0) {
            for (i = 0; i < rand.nextInt(ConfigurationUtil.OreConfig.jade.maxVeinsPerChunk); ++i) {
                posX = chunkX + rand.nextInt(16);
                posY = 7 + rand.nextInt(13);
                posZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(BlockRegister.oreJade.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.jade.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.jade.maxOresPerVein) + 1)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.OreConfig.sapphire.maxVeinsPerChunk > 0) {
            for (i = 0; i < rand.nextInt(ConfigurationUtil.OreConfig.sapphire.maxVeinsPerChunk); ++i) {
                posX = chunkX + rand.nextInt(16);
                posY = 4 + rand.nextInt(8);
                posZ = chunkZ + rand.nextInt(16);
                new WorldGenMinable(BlockRegister.oreSapphire.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.sapphire.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.sapphire.maxOresPerVein) + 1)).func_180709_b(world, rand, new BlockPos(posX, posY, posZ));
            }
        }
    }

    private static void doStructureGen(World world, Random rand, int chunkX, int chunkZ) {
        int posZ;
        int posY;
        int posX;
        Block block;
        Biome biome = world.func_180494_b(new BlockPos(chunkX, 0, chunkZ));
        if (!(biome != Biomes.field_76771_b && biome != Biomes.field_150575_M || ConfigurationUtil.StructureConfig.overworld.amphibiyteCoveSpawnChance <= 0 || rand.nextInt(ConfigurationUtil.StructureConfig.overworld.amphibiyteCoveSpawnChance) != 0 || (block = world.func_180495_p(new BlockPos((posX = chunkX + rand.nextInt(13)) + 8, (posY = world.func_189649_b(posX + 8, (posZ = chunkZ + rand.nextInt(12)) + 8)) - 1, posZ + 9)).func_177230_c()) != Blocks.field_150354_m && block != Blocks.field_150351_n)) {
            StructuresHandler.generateStructure("AmphibiyteCove", world, rand, new BlockPos(posX, posY - 8, posZ));
        }
        if (ConfigurationUtil.StructureConfig.overworld.ruinedTeleporterFrameSpawnChance > 0 && rand.nextInt(ConfigurationUtil.StructureConfig.overworld.ruinedTeleporterFrameSpawnChance) == 0) {
            posX = chunkX + rand.nextInt(16);
            posZ = chunkZ + rand.nextInt(15);
            posY = rand.nextInt(10) + 10;
            if (world.func_180495_p(new BlockPos(posX + 5, posY, posZ + 7)).func_177230_c() != Blocks.field_150350_a) {
                StructuresHandler.generateStructure("RuinedTeleporterFrame", world, rand, new BlockPos(posX, posY, posZ));
            }
        }
        if (ConfigurationUtil.StructureConfig.overworld.windRuneShrineSpawnChance > 0 && rand.nextInt(ConfigurationUtil.StructureConfig.overworld.windRuneShrineSpawnChance) == 0 && (posY = world.func_189649_b(posX = chunkX + rand.nextInt(16), posZ = chunkZ + rand.nextInt(16))) >= 95 && world.func_180495_p(new BlockPos(posX + 3, posY + 30, posZ + 3)).func_177230_c() == Blocks.field_150350_a) {
            StructuresHandler.generateStructure("WindRuneShrine", world, rand, new BlockPos(posX, Math.min(posY + 30, 240), posZ));
        }
    }
}

