/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.precasia.biomes;

import com.google.common.base.Predicate;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomePrecasia
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Precasian Forest");

    public BiomePrecasia() {
        super(properties);
        this.setRegistryName("aoa3", "precasia");
        this.field_76752_A = BlockRegister.getUnmappedBlock("precasia_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("high_precasia_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomePrecasiaDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE});
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(2.0f);
        properties.func_185395_b(100.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.4f);
    }

    public class BiomePrecasiaDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < ConfigurationUtil.OreConfig.skullboneFragments.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreSkullboneFragments.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.skullboneFragments.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.skullboneFragments.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stonePrecasiaLow)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(40), rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.footboneFragments.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreFootboneFragments.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.footboneFragments.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.footboneFragments.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stonePrecasiaLow)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(40), rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.legboneFragments.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreLegboneFragments.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.legboneFragments.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.legboneFragments.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stonePrecasiaLow)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(40), rand.nextInt(16)));
            }
            for (i = 0; i < ConfigurationUtil.OreConfig.chestboneFragments.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreChestboneFragments.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.chestboneFragments.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.chestboneFragments.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stonePrecasiaLow)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(16), rand.nextInt(40), rand.nextInt(16)));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < 25; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                if (rand.nextBoolean()) {
                    world.func_175656_a(pos.func_177984_a(), BlockRegister.plantLuconGrass.func_176223_P());
                    continue;
                }
                world.func_175656_a(pos.func_177984_a(), BlockRegister.plantTangleThorns.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block5: for (int i = 0; i < 3; ++i) {
                switch (rand.nextInt(3)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(14);
                        posZ = basePos.func_177952_p() + rand.nextInt(14);
                        posY = world.func_189649_b(posX + 8, posZ + 8);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 8, posY - 1, posZ + 8)) != biome.field_76752_A) continue block5;
                        StructuresHandler.generateStructure("StranglewoodTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block5;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 6, posZ + 5);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 5)) != biome.field_76752_A) continue block5;
                        StructuresHandler.generateStructure("StranglewoodTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block5;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 6, posZ + 6);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 6, posY - 1, posZ + 6)) != biome.field_76752_A) continue block5;
                        StructuresHandler.generateStructure("LucalusTree", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

