/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.runandor.biomes;

import com.google.common.base.Predicate;
import java.awt.Color;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeRunandor
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Runandor");

    public BiomeRunandor() {
        super(properties);
        this.setRegistryName("aoa3", "runandor");
        this.field_76752_A = BlockRegister.getUnmappedBlock("runic_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("runic_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeRunandorDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.MOUNTAIN});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.BLUE.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(0.5f);
        properties.func_185395_b(0.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.4f);
    }

    public class BiomeRunandorDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < ConfigurationUtil.OreConfig.elecanium.veinsPerChunk; ++i) {
                new WorldGenMinable(BlockRegister.oreElecanium.func_176223_P(), Math.max(ConfigurationUtil.OreConfig.elecanium.minOresPerVein, rand.nextInt(ConfigurationUtil.OreConfig.elecanium.maxOresPerVein) + 1), (Predicate)BlockMatcher.func_177642_a((Block)BlockRegister.stoneRunic)).func_180709_b(world, rand, basePos.func_177982_a(rand.nextInt(14) + 1, rand.nextInt(35) + 1, rand.nextInt(14) + 1));
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block5: for (int i = 0; i < 85; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, (posY = world.func_189649_b(posX, posZ = basePos.func_177952_p() + rand.nextInt(16))) - 1, posZ)) != biome.field_76752_A) continue;
                switch (rand.nextInt(3)) {
                    case 0: {
                        world.func_175656_a(pos.func_177984_a(), BlockRegister.plantRunicBush.func_176223_P());
                        continue block5;
                    }
                    case 1: {
                        world.func_175656_a(pos.func_177984_a(), BlockRegister.plantRuneBulbs.func_176223_P());
                        continue block5;
                    }
                    case 2: {
                        world.func_175656_a(pos.func_177984_a(), BlockRegister.plantMagias.func_176223_P());
                    }
                }
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            block8: for (int i = 0; i < 2; ++i) {
                switch (rand.nextInt(6)) {
                    case 0: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block8;
                        StructuresHandler.generateStructure("RunicTree1", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 1: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 2, posZ + 2);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) continue block8;
                        StructuresHandler.generateStructure("RunicTree2", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 2: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 1, posZ + 1);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A) continue block8;
                        StructuresHandler.generateStructure("RunicTree3", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 3: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 2, posZ + 2);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 2, posY - 1, posZ + 2)) != biome.field_76752_A) continue block8;
                        StructuresHandler.generateStructure("RunicTree4", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 4: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 3, posZ + 3);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 3, posY - 1, posZ + 3)) != biome.field_76752_A) continue block8;
                        StructuresHandler.generateStructure("RunicTree5", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                        continue block8;
                    }
                    case 5: {
                        posX = basePos.func_177958_n() + rand.nextInt(16);
                        posZ = basePos.func_177952_p() + rand.nextInt(16);
                        posY = world.func_189649_b(posX + 4, posZ + 4);
                        if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 4, posY - 1, posZ + 4)) != biome.field_76752_A) continue block8;
                        StructuresHandler.generateStructure("RunicTree6", world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
                    }
                }
            }
        }
    }
}

