/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.shyrelands;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.tslat.aoa3.common.registration.BiomeRegister;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class ChunkGenShyrelands
implements IChunkGenerator {
    private final World world;
    private final Random rand;
    private ChunkPrimer primer;
    private final Biome biome = BiomeRegister.biomeShyrelands;
    private int x;
    private int y;
    private int z;
    private final IBlockState whiteBricks = BlockRegister.bricksShyreWhite.func_176223_P();
    private final IBlockState yellowBricks = BlockRegister.bricksShyreYellow.func_176223_P();
    private final IBlockState glass = BlockRegister.glassShyre.func_176223_P();
    private final IBlockState cloud = BlockRegister.shyreCloud.func_176223_P();

    protected ChunkGenShyrelands(World world) {
        this.world = world;
        this.rand = new Random(world.func_72905_C());
        this.world.func_181544_b(0);
    }

    public Chunk func_185932_a(int chunkX, int chunkZ) {
        this.rand.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        this.primer = new ChunkPrimer();
        this.setBlocksInChunk();
        Chunk chunk = new Chunk(this.world, this.primer, chunkX, chunkZ);
        this.correctCloudBlocks(chunk);
        byte[] biomeArray = chunk.func_76605_m();
        for (int i = 0; i < biomeArray.length; ++i) {
            biomeArray[i] = (byte)Biome.func_185362_a((Biome)this.biome);
        }
        chunk.func_76603_b();
        return chunk;
    }

    private void setBlocksInChunk() {
        this.x = 0;
        while (this.x <= 15) {
            this.z = 0;
            while (this.z <= 15) {
                if (this.rand.nextInt(3) == 0) {
                    this.primer.func_177855_a(this.x, 64, this.z, Blocks.field_180401_cv.func_176223_P());
                }
                ++this.z;
            }
            ++this.x;
        }
        this.setAllBlocksInRegion(0, 0, 0, 15, 29, 15, BlockRegister.stoneShyrelands.func_176223_P());
        this.setAllBlocksInRegion(1, 30, 1, 14, 30, 14, BlockRegister.grassShyrelands.func_176223_P());
        this.setAllBlocksInRegion(0, 30, 0, 15, 30, 0, this.whiteBricks);
        this.setAllBlocksInRegion(0, 30, 15, 15, 30, 15, this.whiteBricks);
        this.setAllBlocksInRegion(0, 30, 1, 0, 30, 14, this.whiteBricks);
        this.setAllBlocksInRegion(15, 30, 1, 15, 30, 14, this.whiteBricks);
        this.setAllBlocksInRegion(0, 46, 0, 0, 54, 0, this.whiteBricks);
        this.setAllBlocksInRegion(0, 46, 15, 0, 54, 15, this.whiteBricks);
        this.setAllBlocksInRegion(15, 46, 0, 15, 54, 0, this.whiteBricks);
        this.setAllBlocksInRegion(15, 46, 15, 15, 54, 15, this.whiteBricks);
        this.setAllBlocksInRegion(0, 55, 0, 15, 55, 0, this.whiteBricks);
        this.setAllBlocksInRegion(0, 55, 15, 15, 55, 15, this.whiteBricks);
        this.setAllBlocksInRegion(0, 55, 1, 0, 55, 14, this.whiteBricks);
        this.setAllBlocksInRegion(15, 55, 1, 15, 55, 14, this.whiteBricks);
        this.setAllBlocksInRegion(1, 46, 0, 14, 54, 0, this.glass);
        this.setAllBlocksInRegion(1, 46, 15, 14, 54, 15, this.glass);
        this.setAllBlocksInRegion(0, 46, 1, 0, 54, 14, this.glass);
        this.setAllBlocksInRegion(15, 46, 1, 15, 54, 14, this.glass);
        this.setAllBlocksInRegion(0, 45, 0, 15, 45, 0, this.yellowBricks);
        this.setAllBlocksInRegion(0, 45, 15, 15, 45, 15, this.yellowBricks);
        this.setAllBlocksInRegion(0, 45, 1, 0, 45, 14, this.yellowBricks);
        this.setAllBlocksInRegion(15, 45, 1, 15, 45, 14, this.yellowBricks);
        this.setAllBlocksInRegion(0, 31, 0, 3, 44, 0, this.yellowBricks);
        this.setAllBlocksInRegion(12, 31, 0, 14, 44, 0, this.yellowBricks);
        this.setAllBlocksInRegion(0, 31, 15, 3, 44, 15, this.yellowBricks);
        this.setAllBlocksInRegion(12, 31, 15, 15, 44, 15, this.yellowBricks);
        this.setAllBlocksInRegion(0, 31, 0, 0, 44, 3, this.yellowBricks);
        this.setAllBlocksInRegion(0, 31, 12, 0, 44, 14, this.yellowBricks);
        this.setAllBlocksInRegion(15, 31, 0, 15, 44, 3, this.yellowBricks);
        this.setAllBlocksInRegion(15, 31, 12, 15, 44, 14, this.yellowBricks);
        this.setAllBlocksInRegion(4, 31, 0, 4, 44, 0, this.whiteBricks);
        this.setAllBlocksInRegion(11, 31, 0, 11, 44, 0, this.whiteBricks);
        this.setAllBlocksInRegion(4, 31, 15, 4, 44, 15, this.whiteBricks);
        this.setAllBlocksInRegion(11, 31, 15, 11, 44, 15, this.whiteBricks);
        this.setAllBlocksInRegion(0, 31, 4, 0, 44, 4, this.whiteBricks);
        this.setAllBlocksInRegion(0, 31, 11, 0, 44, 11, this.whiteBricks);
        this.setAllBlocksInRegion(15, 31, 4, 15, 44, 4, this.whiteBricks);
        this.setAllBlocksInRegion(15, 31, 11, 15, 44, 11, this.whiteBricks);
        this.setAllBlocksInRegion(5, 44, 0, 10, 44, 0, this.whiteBricks);
        this.setAllBlocksInRegion(5, 44, 15, 10, 44, 15, this.whiteBricks);
        this.setAllBlocksInRegion(0, 44, 5, 0, 44, 10, this.whiteBricks);
        this.setAllBlocksInRegion(15, 44, 5, 15, 44, 10, this.whiteBricks);
        this.buildRandomDoor(EnumFacing.NORTH);
        this.buildRandomDoor(EnumFacing.SOUTH);
        this.buildRandomDoor(EnumFacing.EAST);
        this.buildRandomDoor(EnumFacing.WEST);
        this.x = 0;
        while (this.x <= 15) {
            this.y = 31;
            while (this.y <= 45) {
                if (this.rand.nextInt(12) == 0 && this.primer.func_177856_a(this.x, this.y, 0).func_177230_c() == BlockRegister.bricksShyreYellow) {
                    this.primer.func_177855_a(this.x, this.y, 0, this.glass);
                }
                if (this.rand.nextInt(12) == 0 && this.primer.func_177856_a(this.x, this.y, 0).func_177230_c() == BlockRegister.bricksShyreYellow) {
                    this.primer.func_177855_a(this.x, this.y, 15, this.glass);
                }
                ++this.y;
            }
            ++this.x;
        }
        this.z = 0;
        while (this.z <= 15) {
            this.y = 31;
            while (this.y <= 45) {
                if (this.rand.nextInt(12) == 0 && this.primer.func_177856_a(0, this.y, this.z).func_177230_c() == BlockRegister.bricksShyreYellow) {
                    this.primer.func_177855_a(0, this.y, this.z, this.glass);
                }
                if (this.rand.nextInt(12) == 0 && this.primer.func_177856_a(15, this.y, this.z).func_177230_c() == BlockRegister.bricksShyreYellow) {
                    this.primer.func_177855_a(15, this.y, this.z, this.glass);
                }
                ++this.y;
            }
            ++this.z;
        }
        this.x = 0;
        while (this.x <= 15) {
            this.y = 0;
            while (this.y <= 2) {
                this.z = 0;
                while (this.z <= 15) {
                    this.primer.func_177855_a(this.x, this.y, this.z, BlockRegister.dimensionalFabric.func_176223_P());
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    private void buildRandomDoor(EnumFacing side) {
        block0 : switch (side) {
            case NORTH: {
                this.z = 0;
            }
            case SOUTH: {
                if (side == EnumFacing.SOUTH) {
                    this.z = 15;
                }
                switch (this.rand.nextInt(5)) {
                    case 0: {
                        this.primer.func_177855_a(5, 43, this.z, this.glass);
                        this.primer.func_177855_a(6, 43, this.z, this.glass);
                        this.primer.func_177855_a(7, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 43, this.z, this.glass);
                        this.primer.func_177855_a(10, 43, this.z, this.glass);
                        this.primer.func_177855_a(5, 42, this.z, this.glass);
                        this.primer.func_177855_a(6, 42, this.z, this.glass);
                        this.primer.func_177855_a(7, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 42, this.z, this.glass);
                        this.primer.func_177855_a(10, 42, this.z, this.glass);
                        this.primer.func_177855_a(5, 41, this.z, this.glass);
                        this.primer.func_177855_a(6, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(7, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 41, this.z, this.glass);
                        this.primer.func_177855_a(5, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(6, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 40, this.z, this.whiteBricks);
                        break;
                    }
                    case 1: {
                        this.primer.func_177855_a(5, 43, this.z, this.glass);
                        this.primer.func_177855_a(6, 43, this.z, this.glass);
                        this.primer.func_177855_a(7, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 43, this.z, this.glass);
                        this.primer.func_177855_a(10, 43, this.z, this.glass);
                        this.primer.func_177855_a(5, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(6, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(7, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(5, 41, this.z, this.glass);
                        this.primer.func_177855_a(6, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 41, this.z, this.glass);
                        this.primer.func_177855_a(5, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(6, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 40, this.z, this.whiteBricks);
                        break;
                    }
                    case 2: {
                        this.primer.func_177855_a(5, 43, this.z, this.glass);
                        this.primer.func_177855_a(6, 43, this.z, this.glass);
                        this.primer.func_177855_a(7, 43, this.z, this.glass);
                        this.primer.func_177855_a(8, 43, this.z, this.glass);
                        this.primer.func_177855_a(9, 43, this.z, this.glass);
                        this.primer.func_177855_a(10, 43, this.z, this.glass);
                        this.primer.func_177855_a(5, 42, this.z, this.glass);
                        this.primer.func_177855_a(6, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(7, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 42, this.z, this.glass);
                        this.primer.func_177855_a(5, 41, this.z, this.glass);
                        this.primer.func_177855_a(6, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 41, this.z, this.glass);
                        this.primer.func_177855_a(5, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(6, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 40, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 40, this.z, this.whiteBricks);
                        break;
                    }
                    case 3: {
                        this.primer.func_177855_a(5, 43, this.z, this.glass);
                        this.primer.func_177855_a(6, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 43, this.z, this.glass);
                        this.primer.func_177855_a(5, 42, this.z, this.glass);
                        this.primer.func_177855_a(6, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 42, this.z, this.glass);
                        this.primer.func_177855_a(5, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(6, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 41, this.z, this.whiteBricks);
                        break;
                    }
                    case 4: {
                        this.primer.func_177855_a(5, 43, this.z, this.glass);
                        this.primer.func_177855_a(6, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(7, 43, this.z, this.glass);
                        this.primer.func_177855_a(8, 43, this.z, this.glass);
                        this.primer.func_177855_a(9, 43, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 43, this.z, this.glass);
                        this.primer.func_177855_a(5, 42, this.z, this.glass);
                        this.primer.func_177855_a(6, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(7, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(8, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 42, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 42, this.z, this.glass);
                        this.primer.func_177855_a(5, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(6, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(9, 41, this.z, this.whiteBricks);
                        this.primer.func_177855_a(10, 41, this.z, this.whiteBricks);
                    }
                }
                break;
            }
            case WEST: {
                this.x = 0;
            }
            case EAST: {
                if (side == EnumFacing.EAST) {
                    this.x = 15;
                }
                switch (this.rand.nextInt(5)) {
                    case 0: {
                        this.primer.func_177855_a(this.x, 43, 5, this.glass);
                        this.primer.func_177855_a(this.x, 43, 6, this.glass);
                        this.primer.func_177855_a(this.x, 43, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 9, this.glass);
                        this.primer.func_177855_a(this.x, 43, 10, this.glass);
                        this.primer.func_177855_a(this.x, 42, 5, this.glass);
                        this.primer.func_177855_a(this.x, 42, 6, this.glass);
                        this.primer.func_177855_a(this.x, 42, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 9, this.glass);
                        this.primer.func_177855_a(this.x, 42, 10, this.glass);
                        this.primer.func_177855_a(this.x, 41, 5, this.glass);
                        this.primer.func_177855_a(this.x, 41, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 10, this.glass);
                        this.primer.func_177855_a(this.x, 40, 5, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 10, this.whiteBricks);
                        break block0;
                    }
                    case 1: {
                        this.primer.func_177855_a(this.x, 43, 5, this.glass);
                        this.primer.func_177855_a(this.x, 43, 6, this.glass);
                        this.primer.func_177855_a(this.x, 43, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 9, this.glass);
                        this.primer.func_177855_a(this.x, 43, 10, this.glass);
                        this.primer.func_177855_a(this.x, 42, 5, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 10, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 5, this.glass);
                        this.primer.func_177855_a(this.x, 41, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 10, this.glass);
                        this.primer.func_177855_a(this.x, 40, 5, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 10, this.whiteBricks);
                        break block0;
                    }
                    case 2: {
                        this.primer.func_177855_a(this.x, 43, 5, this.glass);
                        this.primer.func_177855_a(this.x, 43, 6, this.glass);
                        this.primer.func_177855_a(this.x, 43, 7, this.glass);
                        this.primer.func_177855_a(this.x, 43, 8, this.glass);
                        this.primer.func_177855_a(this.x, 43, 9, this.glass);
                        this.primer.func_177855_a(this.x, 43, 10, this.glass);
                        this.primer.func_177855_a(this.x, 42, 5, this.glass);
                        this.primer.func_177855_a(this.x, 42, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 10, this.glass);
                        this.primer.func_177855_a(this.x, 41, 5, this.glass);
                        this.primer.func_177855_a(this.x, 41, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 10, this.glass);
                        this.primer.func_177855_a(this.x, 40, 5, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 40, 10, this.whiteBricks);
                        break block0;
                    }
                    case 3: {
                        this.primer.func_177855_a(this.x, 43, 5, this.glass);
                        this.primer.func_177855_a(this.x, 43, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 10, this.glass);
                        this.primer.func_177855_a(this.x, 42, 5, this.glass);
                        this.primer.func_177855_a(this.x, 42, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 10, this.glass);
                        this.primer.func_177855_a(this.x, 41, 5, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 10, this.whiteBricks);
                        break block0;
                    }
                    case 4: {
                        this.primer.func_177855_a(this.x, 43, 5, this.glass);
                        this.primer.func_177855_a(this.x, 43, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 7, this.glass);
                        this.primer.func_177855_a(this.x, 43, 8, this.glass);
                        this.primer.func_177855_a(this.x, 43, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 43, 10, this.glass);
                        this.primer.func_177855_a(this.x, 42, 5, this.glass);
                        this.primer.func_177855_a(this.x, 42, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 7, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 8, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 42, 10, this.glass);
                        this.primer.func_177855_a(this.x, 41, 5, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 6, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 9, this.whiteBricks);
                        this.primer.func_177855_a(this.x, 41, 10, this.whiteBricks);
                    }
                }
            }
        }
    }

    private void correctCloudBlocks(Chunk chunk) {
        this.x = 0;
        while (this.x <= 15) {
            this.z = 0;
            while (this.z <= 15) {
                if (chunk.func_186032_a(this.x, 64, this.z).func_177230_c() == Blocks.field_180401_cv) {
                    chunk.func_177436_a(new BlockPos(this.x, 64, this.z), this.cloud);
                }
                ++this.z;
            }
            ++this.x;
        }
    }

    private void setAllBlocksInRegion(int lowerX, int lowerY, int lowerZ, int upperX, int upperY, int upperZ, IBlockState block) {
        this.x = lowerX;
        while (this.x <= upperX) {
            this.y = lowerY;
            while (this.y <= upperY) {
                this.z = lowerZ;
                while (this.z <= upperZ) {
                    this.primer.func_177855_a(this.x, this.y, this.z, block);
                    ++this.z;
                }
                ++this.y;
            }
            ++this.x;
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        int y;
        int z;
        int x;
        this.rand.setSeed(this.world.func_72905_C());
        long a = this.rand.nextLong() / 2L * 2L + 1L;
        long b = this.rand.nextLong() / 2L * 2L + 1L;
        int baseX = chunkX * 16 + 1;
        int baseZ = chunkZ * 16 + 1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        BlockPos basePos = new BlockPos(baseX, 0, baseZ);
        Biome biome = this.world.func_180494_b(basePos);
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        if (ConfigurationUtil.StructureConfig.shyrelands.craexxeusTowerSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.shyrelands.craexxeusTowerSpawnChance) == 0) {
            x = baseX + 3;
            z = baseZ + 3;
            y = 31;
            StructuresHandler.generateStructure("CraexxeusTower", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
        } else if (ConfigurationUtil.StructureConfig.shyrelands.whitewashingStationSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.shyrelands.whitewashingStationSpawnChance) == 0) {
            StructuresHandler.generateStructure("WhitewashingStation", this.world, this.rand, (BlockPos)pos.func_181079_c(baseX, 31, baseZ));
        } else if (ConfigurationUtil.StructureConfig.shyrelands.shyreDecorationSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.shyrelands.shyreDecorationSpawnChance) == 0) {
            AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
            switch (this.rand.nextInt(7)) {
                case 0: {
                    structure = StructuresHandler.getStructure("DivinePlatform");
                    break;
                }
                case 1: {
                    structure = StructuresHandler.getStructure("ArcWizardCheckpoint");
                    break;
                }
                case 2: {
                    structure = StructuresHandler.getStructure("SoulscorneAmbush");
                    break;
                }
                case 3: {
                    structure = StructuresHandler.getStructure("StrangeShrine");
                    break;
                }
                case 4: {
                    structure = StructuresHandler.getStructure("ShyreDecoration1");
                    break;
                }
                case 5: {
                    structure = StructuresHandler.getStructure("ShyreDecoration2");
                    break;
                }
                case 6: {
                    structure = StructuresHandler.getStructure("ShyreDecoration3");
                }
            }
            StructuresHandler.generateStructure(structure, this.world, this.rand, (BlockPos)pos.func_181079_c(baseX, 31, baseZ));
        }
        if (ConfigurationUtil.StructureConfig.shyrelands.shyreDungeonSpawnChance > 0 && this.rand.nextInt(ConfigurationUtil.StructureConfig.shyrelands.shyreDungeonSpawnChance) == 0) {
            switch (this.rand.nextInt(3)) {
                case 0: {
                    x = baseX + this.rand.nextInt(10);
                    z = baseZ + this.rand.nextInt(4);
                    y = this.rand.nextInt(15) + 2;
                    StructuresHandler.generateStructure("LightwalkerDungeon", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 1: {
                    x = baseX + this.rand.nextInt(15);
                    z = baseZ + this.rand.nextInt(15);
                    y = this.rand.nextInt(15) + 2;
                    StructuresHandler.generateStructure("LuxocronDungeon", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                    break;
                }
                case 2: {
                    x = baseX;
                    z = baseZ + this.rand.nextInt(15);
                    y = this.rand.nextInt(15) + 2;
                    StructuresHandler.generateStructure("ShyreTrollDungeon", this.world, this.rand, (BlockPos)pos.func_181079_c(x, y, z));
                }
            }
        }
        this.rand.setSeed((long)chunkX * a + (long)chunkZ * b ^ this.world.func_72905_C());
        biome.func_180624_a(this.world, this.rand, basePos);
        WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(baseX + 8), (int)(baseZ + 8), (int)16, (int)16, (Random)this.rand);
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        return this.world.func_180494_b(pos).func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
        return false;
    }
}

