/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.dimension.shyrelands.biomes;

import java.awt.Color;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.dimension.AoABiomeDecorator;
import net.tslat.aoa3.structure.AoAStructure;
import net.tslat.aoa3.structure.StructuresHandler;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class BiomeShyrelands
extends Biome {
    private static final Biome.BiomeProperties properties = new Biome.BiomeProperties("Shyrelands");

    public BiomeShyrelands() {
        super(properties);
        this.setRegistryName("aoa3", "shyrelands");
        this.field_76752_A = BlockRegister.getUnmappedBlock("shyrelands_grass").func_176223_P();
        this.field_76753_B = BlockRegister.getUnmappedBlock("shyrelands_stone").func_176223_P();
        this.field_82914_M.clear();
        this.field_76762_K.clear();
        this.field_76761_J.clear();
        this.field_76755_L.clear();
        this.field_76760_I = new BiomeShyrelandsDecorator();
    }

    public void biomeInit() {
        BiomeDictionary.addTypes((Biome)this, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.MAGICAL});
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float currentTemperature) {
        return Color.BLUE.getRGB();
    }

    static {
        properties.func_185396_a();
        properties.func_185410_a(2.0f);
        properties.func_185395_b(500.0f);
        properties.func_185396_a();
        properties.func_185398_c(0.0f);
        properties.func_185400_d(0.1f);
    }

    public class BiomeShyrelandsDecorator
    extends AoABiomeDecorator {
        @Override
        protected void doOreGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < Math.max(ConfigurationUtil.OreConfig.shyre.minBlocksPerChunk, rand.nextInt(ConfigurationUtil.OreConfig.shyre.maxBlocksPerChunk)); ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(16);
                posZ = basePos.func_177952_p() + rand.nextInt(16);
                posY = rand.nextInt(25) + 2;
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY, posZ)) != biome.field_76753_B) continue;
                if (rand.nextInt(8) == 0) {
                    world.func_175656_a((BlockPos)pos, BlockRegister.oreShyregem.func_176223_P());
                    continue;
                }
                world.func_175656_a((BlockPos)pos, BlockRegister.oreShyrestone.func_176223_P());
            }
        }

        @Override
        protected void doPlantGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            int i;
            for (i = 0; i < 9; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(14);
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX, posY = 54, posZ = basePos.func_177952_p() + rand.nextInt(14))).func_177230_c() != Blocks.field_150350_a) continue;
                world.func_175656_a(pos.func_177984_a(), BlockRegister.glassShyre.func_176223_P());
                StructuresHandler.generateStructure("InvertedShyreStock", world, rand, (BlockPos)pos);
            }
            block8: for (i = 0; i < 64; ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(14);
                if (!world.func_175623_d((BlockPos)pos.func_181079_c(posX, posY = 31, posZ = basePos.func_177952_p() + rand.nextInt(14))) || world.func_180495_p(pos.func_177977_b()) != biome.field_76752_A) continue;
                switch (rand.nextInt(5)) {
                    case 0: {
                        if (rand.nextInt(3) != 0) continue block8;
                        StructuresHandler.generateStructure("ShyreStock", world, rand, (BlockPos)pos);
                        continue block8;
                    }
                    case 1: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantShyreWeed.func_176223_P());
                        continue block8;
                    }
                    case 2: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantArcbulb.func_176223_P());
                        continue block8;
                    }
                    case 3: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantArcflower.func_176223_P());
                        continue block8;
                    }
                    case 4: {
                        world.func_175656_a((BlockPos)pos, BlockRegister.plantHorizonDaisies.func_176223_P());
                    }
                }
            }
            if (rand.nextInt(40) == 0 && world.func_175623_d((BlockPos)pos.func_181079_c(posX = basePos.func_177958_n() + rand.nextInt(14), 31, posZ = basePos.func_177952_p() + rand.nextInt(14))) && world.func_180495_p(pos.func_177977_b()) == biome.field_76752_A) {
                world.func_175656_a((BlockPos)pos, BlockRegister.plantTrilliadBloom.func_176223_P());
            }
        }

        @Override
        protected void doTreeGen(World world, Biome biome, Random rand, BlockPos basePos, BlockPos.MutableBlockPos pos, int posX, int posY, int posZ) {
            for (int i = 0; i < rand.nextInt(8); ++i) {
                posX = basePos.func_177958_n() + rand.nextInt(12);
                posZ = basePos.func_177952_p() + rand.nextInt(12);
                posY = 31;
                AoAStructure structure = StructuresHandler.EMPTY_STRUCTURE;
                if (world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY - 1, posZ + 1)) != biome.field_76752_A || !world.func_180495_p((BlockPos)pos.func_181079_c(posX + 1, posY, posZ + 1)).func_185904_a().func_76222_j()) continue;
                switch (rand.nextInt(4)) {
                    case 0: {
                        structure = StructuresHandler.getStructure("ShyreTree1");
                        break;
                    }
                    case 1: {
                        structure = StructuresHandler.getStructure("ShyreTree2");
                        break;
                    }
                    case 2: {
                        structure = StructuresHandler.getStructure("BrightShyreTree1");
                        break;
                    }
                    case 3: {
                        structure = StructuresHandler.getStructure("BrightShyreTree2");
                    }
                }
                StructuresHandler.generateStructure(structure, world, rand, (BlockPos)pos.func_181079_c(posX, posY, posZ));
            }
        }
    }
}

