/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.tslat.aoa3.entity.base.ai.RoamingFlightMoveHelper;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIFlyingFindNearestAttackableTargetHunter;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIFlyingLookAround;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIFlyingMeleeAttack;
import net.tslat.aoa3.entity.base.ai.mob.EntityAIRandomFly;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.event.dimension.OverworldEvents;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.WorldUtil;

public abstract class AoAFlyingMeleeMob
extends EntityFlying
implements IMob {
    protected final TreeSet<Enums.MobProperties> mobProperties = this instanceof SpecialPropertyEntity ? new TreeSet() : null;

    public AoAFlyingMeleeMob(World world, float entityWidth, float entityHeight) {
        super(world);
        this.field_70765_h = new RoamingFlightMoveHelper(this);
        this.func_70105_a(entityWidth, entityHeight);
        this.setXpValue((int)this.getBaseMaxHealth() / 10);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIRandomFly(this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFlyingLookAround(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFlyingMeleeAttack(this, 0.6f, false));
        this.field_70715_bh.func_75776_a(1, new EntityAIFlyingFindNearestAttackableTargetHunter<AoAMinion>((EntityLiving)this, AoAMinion.class, EntityTameable::func_70909_n));
        this.field_70715_bh.func_75776_a(2, new EntityAIFlyingFindNearestAttackableTargetHunter<EntityPlayer>((EntityLiving)this, EntityPlayer.class));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.getBaseMeleeDamage());
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(36.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(this.getBaseArmour());
    }

    protected abstract double getBaseKnockbackResistance();

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMeleeDamage();

    protected abstract double getBaseMovementSpeed();

    protected double getBaseArmour() {
        return 0.0;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return null;
    }

    @Nonnull
    public PathNavigate func_70661_as() {
        return new PathNavigateFlying((EntityLiving)this, this.field_70170_p);
    }

    protected void setXpValue(int amount) {
        this.field_70728_aV = amount;
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && this.checkWorldRequirements() && this.checkSpawnChance() && this.isValidLightLevel() && this.canSpawnOnBlock(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean isOverworldMob() {
        return false;
    }

    protected boolean isValidLightLevel() {
        int light;
        if (this.isDaylightMob() || !this.isOverworldMob()) {
            if (!this.field_70170_p.func_72935_r() && this.isDaylightMob()) {
                return false;
            }
            return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= this.field_70146_Z.nextInt(8);
        }
        BlockPos blockPos = new BlockPos(this.field_70165_t, this.func_174813_aQ().field_72338_b, this.field_70161_v);
        if (this.field_70170_p.func_175642_b(EnumSkyBlock.SKY, blockPos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        if (this.field_70170_p.func_72911_I()) {
            int skylightSubtracted = this.field_70170_p.func_175657_ab();
            this.field_70170_p.func_175692_b(10);
            light = this.field_70170_p.func_175671_l(blockPos);
            this.field_70170_p.func_175692_b(skylightSubtracted);
        } else {
            light = this.field_70170_p.func_175671_l(blockPos);
        }
        return light <= this.field_70146_Z.nextInt(8);
    }

    protected boolean isDaylightMob() {
        return false;
    }

    private boolean checkSpawnChance() {
        if (this.isOverworldMob()) {
            if (this.isDaylightMob()) {
                return !(this.field_70146_Z.nextDouble() > this.getSpawnChanceFactor());
            }
            return !(this.field_70146_Z.nextDouble() > this.getSpawnChanceFactor() * 4.0);
        }
        return !(this.field_70146_Z.nextDouble() > this.getSpawnChanceFactor());
    }

    protected double getSpawnChanceFactor() {
        return ConfigurationUtil.EntityConfig.mobSpawnFrequencyModifier;
    }

    public int func_70641_bl() {
        return 1;
    }

    protected boolean canSpawnOnBlock(IBlockState block) {
        return block.func_189884_a((Entity)this);
    }

    private boolean checkWorldRequirements() {
        if (this.isOverworldMob() && this.field_70170_p.field_73011_w.getDimension() != 0) {
            EntityRegistry.removeSpawn(((Object)((Object)this)).getClass(), (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{this.field_70170_p.func_180494_b(this.func_180425_c())});
            return false;
        }
        Enums.CreatureEvents eventReq = this.getEventRequirement();
        return eventReq == null || OverworldEvents.isEventActive(eventReq);
    }

    @Nullable
    protected Enums.CreatureEvents getEventRequirement() {
        return null;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
    }

    public boolean func_70652_k(Entity target) {
        boolean attackSuccess;
        float baseDamage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockbackValue = 0;
        if (target instanceof EntityLivingBase) {
            baseDamage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)target).func_70668_bt());
            knockbackValue += EnchantmentHelper.func_77501_a((EntityLivingBase)this);
        }
        if (attackSuccess = target.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), baseDamage)) {
            int fireAspectMod;
            if (knockbackValue > 0) {
                ((EntityLivingBase)target).func_70653_a((Entity)this, (float)knockbackValue * 0.5f, (double)MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)))));
                this.field_70159_w *= 0.6;
                this.field_70179_y *= 0.6;
            }
            if ((fireAspectMod = EnchantmentHelper.func_90036_a((EntityLivingBase)this)) > 0) {
                target.func_70015_d(fireAspectMod * 4);
            }
            if (target instanceof EntityPlayer) {
                ItemStack activeHeldStack;
                EntityPlayer playerTarget = (EntityPlayer)target;
                ItemStack mainHandStack = this.func_184614_ca();
                ItemStack itemStack = activeHeldStack = playerTarget.func_184587_cr() ? playerTarget.func_184607_cu() : ItemStack.field_190927_a;
                if (!mainHandStack.func_190926_b() && !activeHeldStack.func_190926_b() && mainHandStack.func_77973_b().canDisableShield(mainHandStack, activeHeldStack, (EntityLivingBase)playerTarget, (EntityLivingBase)this) && activeHeldStack.func_77973_b().isShield(activeHeldStack, (EntityLivingBase)playerTarget)) {
                    float hasteMod = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)this) * 0.05f;
                    if (this.field_70146_Z.nextFloat() < hasteMod) {
                        playerTarget.func_184811_cZ().func_185145_a(activeHeldStack.func_77973_b(), 100);
                        this.field_70170_p.func_72960_a((Entity)playerTarget, (byte)30);
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, target);
            this.doMeleeEffect(target);
        }
        return attackSuccess;
    }

    protected void doMeleeEffect(Entity target) {
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76380_i) {
            return false;
        }
        if (this.func_190530_aW()) {
            return true;
        }
        return this.isSpecialImmuneTo(source, 1);
    }

    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return false;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.func_184647_J() != null) {
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(this.func_184647_J());
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da() + (float)lootingModifier);
            }
            for (ItemStack stack : lootTable.func_186462_a(this.field_70146_Z, lootBuilder.func_186471_a())) {
                this.func_70099_a(stack, 0.0f);
            }
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        } else {
            super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }
}

