/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base.ai.mob;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumHand;

public class EntityAIFlyingMeleeAttack
extends EntityAIBase {
    private final EntityFlying taskOwner;
    private final float chargingSpeed;
    private int attackCooldown = 0;
    private Path path;
    private int delayTicks;
    private double targetX;
    private double targetY;
    private double targetZ;
    private boolean retainTarget;

    public EntityAIFlyingMeleeAttack(EntityFlying creature, float speed, boolean longMemory) {
        this.taskOwner = creature;
        this.chargingSpeed = speed;
        this.retainTarget = longMemory;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = this.taskOwner.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        this.path = this.taskOwner.func_70661_as().func_75494_a((Entity)target);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReach(target) >= this.taskOwner.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
    }

    public boolean func_75253_b() {
        EntityLivingBase target = this.taskOwner.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (!this.retainTarget) {
            return !this.taskOwner.func_70661_as().func_75500_f();
        }
        return !(target instanceof EntityPlayer) || !((EntityPlayer)target).func_175149_v() && !((EntityPlayer)target).func_184812_l_();
    }

    public void func_75249_e() {
        this.taskOwner.func_70661_as().func_75484_a(this.path, (double)this.chargingSpeed);
        this.delayTicks = 0;
    }

    public void func_75251_c() {
        EntityLivingBase target = this.taskOwner.func_70638_az();
        if (target instanceof EntityPlayer && (((EntityPlayer)target).func_175149_v() || ((EntityPlayer)target).func_184812_l_())) {
            this.taskOwner.func_70624_b(null);
        }
        this.taskOwner.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase target = this.taskOwner.func_70638_az();
        double attackDistance = this.taskOwner.func_70092_e(target.field_70165_t, target.func_174813_aQ().field_72338_b, target.field_70161_v);
        this.taskOwner.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
        --this.delayTicks;
        if ((this.retainTarget || this.taskOwner.func_70635_at().func_75522_a((Entity)target)) && this.delayTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || target.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.taskOwner.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = target.field_70165_t;
            this.targetY = target.func_174813_aQ().field_72338_b;
            this.targetZ = target.field_70161_v;
            this.delayTicks = 4 + this.taskOwner.func_70681_au().nextInt(7);
            if (attackDistance > 1024.0) {
                this.delayTicks += 10;
            } else if (attackDistance < 256.0) {
                this.delayTicks += 5;
            }
            if (!this.taskOwner.func_70661_as().func_75497_a((Entity)target, (double)this.chargingSpeed)) {
                this.delayTicks += 15;
            } else {
                this.taskOwner.func_70605_aq().func_75642_a(this.targetX, this.targetY, this.targetZ, (double)this.chargingSpeed);
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        this.checkAndAttack(target, attackDistance);
    }

    private void checkAndAttack(EntityLivingBase target, double attackDistance) {
        double reach = this.getAttackReach(target);
        if (attackDistance <= reach & this.attackCooldown <= 0) {
            this.attackCooldown = 20;
            this.taskOwner.func_184609_a(EnumHand.MAIN_HAND);
            this.taskOwner.func_70652_k((Entity)target);
        }
    }

    private double getAttackReach(EntityLivingBase target) {
        return (double)this.taskOwner.field_70130_N * 2.0 * (double)this.taskOwner.field_70130_N * 2.0 + (double)target.field_70130_N;
    }
}

