/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.base.ai.mob;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;
import net.tslat.aoa3.utils.skills.HunterUtil;

public class EntityAINearestAttackableTargetHunter<T extends EntityLivingBase>
extends EntityAITarget {
    private final Class<T> targetClass;
    private final int targetChance;
    private final EntityAINearestAttackableTarget.Sorter sorter;
    private final Predicate<? super T> targetSelectorPredicate;
    private T selectedTarget;
    private final int hunterLvl;

    public EntityAINearestAttackableTargetHunter(EntityCreature mob, Class<T> classTarget, boolean checkSight) {
        this(mob, classTarget, checkSight, false);
    }

    public EntityAINearestAttackableTargetHunter(EntityCreature mob, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(mob, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestAttackableTargetHunter(EntityCreature mob, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(mob, checkSight, onlyNearby);
        this.func_75248_a(1);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)mob);
        this.hunterLvl = HunterUtil.getHunterLevel((EntityLivingBase)mob);
        this.targetSelectorPredicate = input -> {
            EntityPlayer pl;
            if (input == null || targetSelector != null && !targetSelector.apply(input)) {
                return false;
            }
            if (input instanceof EntityPlayer) {
                EntityPlayer pl2 = (EntityPlayer)input;
                if (!PredicateUtil.IS_VULNERABLE_PLAYER.apply((Object)pl2)) {
                    return false;
                }
                if (this.hunterLvl > 0 && !PlayerUtil.doesPlayerHaveLevel(pl2, Enums.Skills.HUNTER, this.hunterLvl)) {
                    return false;
                }
            } else if (this.hunterLvl > 0 && input instanceof EntityTameable && (pl = (EntityPlayer)((EntityTameable)input).func_70902_q()) != null && !PlayerUtil.doesPlayerHaveLevel(pl, Enums.Skills.HUNTER, this.hunterLvl)) {
                return false;
            }
            return this.func_75296_a((EntityLivingBase)input, false);
        };
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass == EntityPlayer.class || this.targetClass == EntityPlayerMP.class) {
            this.selectedTarget = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

                @Nullable
                public Double apply(@Nullable EntityPlayer input) {
                    return 1.0;
                }
            }, this.targetSelectorPredicate);
            return this.selectedTarget != null;
        }
        List targetList = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.field_75299_d.func_174813_aQ().func_72314_b(this.func_111175_f(), 4.0, this.func_111175_f()), this.targetSelectorPredicate);
        if (!targetList.isEmpty()) {
            targetList.sort(this.sorter);
            this.selectedTarget = (EntityLivingBase)targetList.get(0);
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.selectedTarget);
        super.func_75249_e();
    }
}

