/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.baroness;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.boss.baroness.EntityBaronBomb;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityBaronessShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityBaroness
extends AoARangedMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/baroness.png");
    public static final float entityWidth = 0.6875f;
    private static final DataParameter<Boolean> INVULNERABLE = EntityDataManager.func_187226_a(EntityBaroness.class, (DataSerializer)DataSerializers.field_187198_h);
    private int invulnerableTicks = 0;
    private int bombCoolown = 150;

    public EntityBaroness(World world) {
        super(world, 0.6875f, 2.75f);
        this.mobProperties.add(Enums.MobProperties.EXPLOSION_IMMUNE);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
    }

    public float func_70047_e() {
        return 1.71875f;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVULNERABLE, (Object)false);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2000.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 8.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    public boolean func_190530_aW() {
        return (Boolean)this.field_70180_af.func_187225_a(INVULNERABLE);
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return source.func_94541_c();
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobArielLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobArielDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobArielHit;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.shotBaronessFire;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityBaroness;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityBaronessShot(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        this.invulnerableTicks = 40;
        this.changeStage(true);
    }

    private void changeStage(boolean invulnerable) {
        this.field_70180_af.func_187227_b(INVULNERABLE, (Object)invulnerable);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_175446_cd()) {
            return;
        }
        if (this.invulnerableTicks > 0) {
            --this.invulnerableTicks;
            if (this.invulnerableTicks == 0) {
                this.changeStage(false);
            }
        }
        if (this.bombCoolown > 0) {
            --this.bombCoolown;
            if (this.bombCoolown == 0) {
                this.bombCoolown = 50 + this.field_70146_Z.nextInt(50);
                EntityLivingBase target = this.func_70638_az();
                if (target != null) {
                    this.func_70024_g(Math.signum((target.field_70165_t - this.field_70165_t) * 2.329), Math.signum((target.field_70163_u + 1.0 - this.field_70163_u) * 0.929), Math.signum(target.field_70161_v - this.field_70161_v) * 2.329);
                }
                if (!this.field_70170_p.field_72995_K) {
                    EntityBaronBomb bomb = new EntityBaronBomb(this);
                    this.field_70170_p.func_72838_d((Entity)bomb);
                    this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.baronBombSpawn, SoundCategory.HOSTILE, 1.0f, 1.0f);
                }
            }
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70645_a(DamageSource cause) {
        EntityPlayer killer;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && (killer = PlayerUtil.getPlayerOrOwnerIfApplicable(cause.func_76346_g())) != null) {
            StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.baroness.kill", killer.getDisplayNameString()), (Entity)this, 50);
        }
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicBaroness;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

