/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.corallus;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.projectiles.mob.EntityCorallusShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityCorallus
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/corallus.png");
    public static final float entityWidth = 0.75f;
    private static final DataParameter<Boolean> ENRAGED = EntityDataManager.func_187226_a(EntityCorallus.class, (DataSerializer)DataSerializers.field_187198_h);
    private int shotCooldown = 7;
    private int shootStageTimer = 0;
    private int jumpCooldown = 320;
    private int rageStateCooldown = 200;

    public EntityCorallus(World world) {
        super(world, 0.75f, 2.875f);
    }

    public float func_70047_e() {
        return 2.72f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ENRAGED, (Object)false);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(52.0);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1800.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.3286;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobCorallusLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobCorallusDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobCorallusHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.heavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityCorallus;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public boolean func_70648_aU() {
        return true;
    }

    private void setEnraged(boolean enraged) {
        this.field_70180_af.func_187227_b(ENRAGED, (Object)enraged);
    }

    public boolean isEnraged() {
        return (Boolean)this.field_70180_af.func_187225_a(ENRAGED);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.jumpCooldown == 0) {
            this.field_70181_x = 1.6;
            this.field_70143_R = -10.0f;
            this.jumpCooldown = 320;
            this.shootStageTimer = 60;
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobCorallusTaunt, SoundCategory.HOSTILE, 1.0f, 1.0f);
        } else {
            --this.jumpCooldown;
        }
        if (this.shootStageTimer > 0) {
            if (this.shotCooldown == 0 && !this.field_70170_p.field_72995_K) {
                List targets = this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(40.0), PredicateUtil.IS_VULNERABLE_PLAYER);
                for (EntityPlayer target : targets) {
                    EntityCorallusShot shot = new EntityCorallusShot(this, (EntityLivingBase)target, 12);
                    shot.func_70012_b(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    this.field_70170_p.func_72838_d((Entity)shot);
                }
                this.shotCooldown = 10 + this.field_70146_Z.nextInt(15);
            } else {
                --this.shotCooldown;
            }
            --this.shootStageTimer;
        }
        --this.rageStateCooldown;
        if (this.rageStateCooldown <= 0) {
            if (this.isEnraged()) {
                if (!this.field_70170_p.field_72995_K) {
                    this.setEnraged(false);
                }
                this.rageStateCooldown = 200;
            } else {
                if (!this.field_70170_p.field_72995_K) {
                    this.setEnraged(true);
                }
                this.rageStateCooldown = 80;
                this.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 80, 3, true, true));
            }
        }
        if (this.func_70090_H()) {
            if (this.field_70159_w > (double)-1.2f && this.field_70159_w < (double)1.2f) {
                this.field_70159_w *= (double)1.2f;
            }
            if (this.field_70179_y > (double)-1.2f && this.field_70179_y < (double)1.2f) {
                this.field_70179_y *= (double)1.2f;
            }
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            target.field_70181_x = -1.799;
            if (!this.func_70090_H()) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 15, true, true));
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 50, 3, true, true));
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.corallus.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicCorallus;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

