/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.crystocore;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityCrystocore
extends AoAFlyingMeleeMob
implements BossEntity,
SpecialPropertyEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/crystocore.png");
    public static final float entityWidth = 2.5f;
    private byte damageType = 0;
    private int changeCooldown = 220;
    private static final DataParameter<Byte> TYPE = EntityDataManager.func_187226_a(EntityCrystocore.class, (DataSerializer)DataSerializers.field_187191_a);

    public EntityCrystocore(World world) {
        super(world, 2.5f, 4.875f);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    public float func_70047_e() {
        return 3.625f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(TYPE, (Object)0);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.6;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 3000.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    public int getType() {
        return ((Byte)this.field_70180_af.func_187225_a(TYPE)).byteValue();
    }

    private void changeState() {
        this.damageType = (byte)this.field_70146_Z.nextInt(6);
        this.field_70180_af.func_187227_b(TYPE, (Object)this.damageType);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobCrystalConstructLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobCrystalConstructDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobCrystalConstructHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityCrystocore;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.changeCooldown > 0) {
                --this.changeCooldown;
            } else {
                PotionEffect effect;
                this.changeCooldown = 220;
                this.changeState();
                switch (this.field_70146_Z.nextInt(6)) {
                    case 0: {
                        effect = new PotionEffect(MobEffects.field_76436_u, 180, 1, true, true);
                        break;
                    }
                    case 1: {
                        effect = new PotionEffect(MobEffects.field_76440_q, 180, 2, true, true);
                        break;
                    }
                    case 2: {
                        effect = new PotionEffect(MobEffects.field_76437_t, 180, 1, true, true);
                        break;
                    }
                    case 3: {
                        effect = new PotionEffect(MobEffects.field_76431_k, 180, 10, true, true);
                        break;
                    }
                    case 4: {
                        effect = new PotionEffect(MobEffects.field_82731_v, 180, 1, true, true);
                        break;
                    }
                    default: {
                        effect = new PotionEffect(MobEffects.field_76421_d, 180, 1, true, true);
                    }
                }
                for (EntityPlayer pl : this.field_70170_p.func_175647_a(EntityPlayer.class, this.func_174813_aQ().func_186662_g(10.0), PredicateUtil.IS_VULNERABLE_PLAYER)) {
                    pl.func_70690_d(effect);
                }
            }
        }
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.crystocore.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            switch (this.damageType) {
                case 0: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 180, 1, true, true));
                    break;
                }
                case 1: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76440_q, 180, 2, true, true));
                    break;
                }
                case 2: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 180, 1, true, true));
                    break;
                }
                case 3: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 180, 10, true, true));
                    break;
                }
                case 4: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 180, 1, true, true));
                    break;
                }
                default: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 180, 1, true, true));
                }
            }
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicCrystocore;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

