/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.dracyon;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tslat.aoa3.common.packet.PacketScreenOverlay;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntitySpectralShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.library.scheduling.async.DracyonCleanupTask;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PacketUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityDracyon
extends AoAFlyingMeleeMob
implements BossEntity,
AoARangedAttacker {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/dracyon.png");
    public static final float entityWidth = 1.4f;

    public EntityDracyon(World world) {
        super(world, 1.4f, 1.3125f);
        this.func_70659_e(3.7f);
    }

    public float func_70047_e() {
        return 1.15625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1700.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 25.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobDracyonLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobDracyonDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobDracyonLiving;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityDracyon;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70146_Z.nextInt(200) == 0 && !this.field_70170_p.field_73011_w.func_177500_n() && this.field_70170_p.func_180495_p(this.func_180425_c()).func_185904_a().func_76222_j()) {
                this.field_70170_p.func_175656_a(this.func_180425_c(), Blocks.field_150355_j.func_176223_P());
                new DracyonCleanupTask(this.field_70170_p, this.func_180425_c()).schedule(5, TimeUnit.SECONDS);
            }
            if (this.field_70146_Z.nextInt(70) == 0 && this.func_70638_az() != null) {
                EntityLivingBase target = this.func_70638_az();
                EntitySpectralShot projectile = new EntitySpectralShot(this, Enums.MobProjectileType.MAGIC);
                double distanceFactorX = target.field_70165_t - projectile.field_70165_t;
                double distanceFactorY = target.func_174813_aQ().field_72338_b + (double)(target.field_70131_O / 3.0f) - projectile.field_70163_u;
                double distanceFactorZ = target.field_70161_v - projectile.field_70161_v;
                double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobDracyonLiving, SoundCategory.HOSTILE, 1.0f, 1.0f);
                projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
                this.field_70170_p.func_72838_d((Entity)projectile);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && !this.func_175446_cd()) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.dracyon.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityPlayerMP) {
            PacketUtil.network.sendTo((IMessage)new PacketScreenOverlay(40, Enums.ScreenOverlays.SCRATCHES), (EntityPlayerMP)target);
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicDracyon;
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (EntityUtil.dealBlasterDamage((EntityLivingBase)this, target, (Entity)projectile, 13.5f, false)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 45, 0, true, true));
        }
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

