/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.fourguardians;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.boss.fourguardians.EntityBlueGuardian;
import net.tslat.aoa3.entity.boss.fourguardians.EntityGreenGuardian;
import net.tslat.aoa3.entity.boss.fourguardians.EntityYellowGuardian;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityRedGuardianShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;

public class EntityRedGuardian
extends AoARangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/red_guardian.png");
    public static final float entityWidth = 1.5f;
    private EntityBlueGuardian blueGuardian;
    private EntityGreenGuardian greenGuardian;
    private EntityYellowGuardian yellowGuardian;

    public EntityRedGuardian(World world) {
        super(world, 1.5f, 2.625f);
    }

    public float func_70047_e() {
        return 1.875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 750.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobGuardianDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobGuardianHit;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.shotGuardianFire;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.checkGuardian((EntityLivingBase)this.blueGuardian) && this.checkGuardian((EntityLivingBase)this.greenGuardian) && this.checkGuardian((EntityLivingBase)this.yellowGuardian)) {
            return LootSystemRegister.entityRedGuardian;
        }
        return null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void setGreenGuardian(EntityGreenGuardian greenGuardian) {
        this.greenGuardian = greenGuardian;
    }

    public void setBlueGuardian(EntityBlueGuardian blueGuardian) {
        this.blueGuardian = blueGuardian;
    }

    public void setYellowGuardian(EntityYellowGuardian yellowGuardian) {
        this.yellowGuardian = yellowGuardian;
    }

    private boolean checkGuardian(EntityLivingBase guardian) {
        return guardian == null || guardian.field_70128_L || guardian.func_110143_aJ() == 0.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic(null);
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        if (target instanceof AoARangedMob && target instanceof BossEntity) {
            return;
        }
        super.doProjectileEntityImpact(projectile, target);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityLivingBase) {
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 40, 2, true, true));
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityRedGuardianShot(this, Enums.MobProjectileType.MAGIC);
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicFourGuardians;
    }
}

