/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.hiveking;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.hiveking.EntityHiveWorker;
import net.tslat.aoa3.entity.minions.EntityHiveSoldier;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.ModUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntityHiveKing
extends AoAMeleeMob
implements BossEntity {
    private static final DataParameter<Integer> GROWTH_PERCENT = EntityDataManager.func_187226_a(EntityHiveKing.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/hive_king.png");
    public static final float entityWidth = 1.2f;
    public static final float entityHeight = 1.5f;
    private int growthPercent = 0;

    public EntityHiveKing(World world) {
        super(world, 1.2f, 1.5f);
        if (!world.field_72995_K) {
            this.field_70180_af.func_187227_b(GROWTH_PERCENT, (Object)100);
            this.growthPercent = 100;
        }
        this.func_70105_a(1.2f / (100.0f / (float)this.growthPercent), 1.5f / (100.0f / (float)this.growthPercent));
    }

    public EntityHiveKing(World world, int growthPercent) {
        this(world);
        this.growthPercent = growthPercent;
        this.field_70180_af.func_187227_b(GROWTH_PERCENT, (Object)growthPercent);
        this.func_70606_j(Math.max(1.0f, this.func_110138_aP() / (100.0f / (float)growthPercent)));
        this.func_94061_f(true);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GROWTH_PERCENT, (Object)0);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobHiveKingLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobHiveKingDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobHiveKingLiving;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.growthPercent >= 100 ? LootSystemRegister.entityHiveKing : null;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public int getGrowthPercent() {
        return this.growthPercent;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.growthPercent < 100) {
            if (!this.field_70170_p.field_72995_K) {
                this.incrementGrowth();
            } else {
                this.growthPercent = (Integer)this.field_70180_af.func_187225_a(GROWTH_PERCENT);
            }
            this.func_70105_a(1.2f / (100.0f / (float)this.growthPercent), 1.5f / (100.0f / (float)this.growthPercent));
            if (this.growthPercent == 100) {
                this.func_94061_f(false);
            }
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(500) == 0) {
            EntityHiveWorker worker = new EntityHiveWorker(this);
            this.field_70170_p.func_72838_d((Entity)worker);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.growthPercent >= 100) {
            return super.func_70097_a(source, amount);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
        return true;
    }

    private void incrementGrowth() {
        ++this.growthPercent;
        this.field_70180_af.func_187227_b(GROWTH_PERCENT, (Object)this.growthPercent);
        this.func_70606_j(this.func_110138_aP() / (100.0f / (float)this.growthPercent));
    }

    public void func_70645_a(DamageSource cause) {
        if (this.growthPercent < 100) {
            return;
        }
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer && (killer = (EntityPlayer)((EntityTameable)source).func_70902_q()) instanceof EntityPlayerMP && source instanceof EntityHiveSoldier) {
                    ModUtil.completeAdvancement((EntityPlayerMP)killer, "barathos/daddy_issues", "hive_soldier_kill");
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.hiveKing.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicHiveKing;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }
}

