/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.kingshroomus;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityWitherBall;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.StringUtil;

public class EntityKingShroomus
extends AoARangedMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/king_shroomus.png");
    public static final float entityWidth = 0.875f;
    private int healingCounter = 0;

    public EntityKingShroomus(World world) {
        super(world, 0.875f, 3.25f);
    }

    public float func_70047_e() {
        return 2.40625f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1800.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 20.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobFungiLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobKingShroomusDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobFungiHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.heavyStep;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.shotWizardBlast;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityKingShroomus;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.healingCounter == 0 && this.field_70146_Z.nextInt(200) == 0) {
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobKingShroomusHeal, SoundCategory.HOSTILE, 1.0f, 1.0f);
            }
            this.healingCounter = 80;
        }
        if (this.healingCounter > 0) {
            --this.healingCounter;
            this.func_70691_i(2.0f);
        }
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityLivingBase) {
            switch (this.field_70146_Z.nextInt(4)) {
                case 0: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 80, 2, true, true));
                    break;
                }
                case 1: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76436_u, 80, 4, true, true));
                    break;
                }
                case 2: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76431_k, 140, 100, true, true));
                    break;
                }
                case 3: {
                    ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 100, 2, true, true));
                }
            }
        }
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityWitherBall(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicKingShroomus;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.kingShroomus.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }
}

