/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.mirage;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntitySpiritualShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;

public class EntityMirage
extends AoARangedMob
implements BossEntity {
    public static final float entityWidth = 0.8f;

    public EntityMirage(World world) {
        super(world, 0.8f, 2.0f);
    }

    public float func_70047_e() {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 750.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 8.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobImmortalLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobImmortalDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187689_f;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.shotMirageFire;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityMirage;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntitySpiritualShot(this, Enums.MobProjectileType.MAGIC);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(80) == 0) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundsRegister.mobMirageTeleport, SoundCategory.HOSTILE, 1.0f, 1.0f);
            if (this.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.immortallis) {
                switch (this.field_70146_Z.nextInt(4)) {
                    case 0: {
                        this.func_70012_b(167.0, 24.0, 8.0, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                        break;
                    }
                    case 1: {
                        this.func_70012_b(168.0, 24.0, -2.0, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                        break;
                    }
                    case 2: {
                        this.func_70012_b(177.0, 24.0, 8.0, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                        break;
                    }
                    case 3: {
                        this.func_70012_b(177.0, 24.0, -2.0, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                    }
                }
            } else {
                int x = (int)(this.field_70146_Z.nextBoolean() ? this.field_70165_t + 5.0 : this.field_70165_t - 5.0);
                int z = (int)(this.field_70146_Z.nextBoolean() ? this.field_70161_v + 5.0 : this.field_70161_v - 5.0);
                this.func_70012_b(x, this.field_70170_p.func_189649_b(x, z), z, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return null;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return null;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

