/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.nethengeicwither;

import java.util.List;
import java.util.Random;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackRanged;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFindEntityNearestPlayer;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedAttacker;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityNethengeicWitherShot;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.PredicateUtil;
import net.tslat.aoa3.utils.StringUtil;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityNethengeicWither
extends EntityMob
implements BossEntity,
IRangedAttackMob,
SpecialPropertyEntity,
AoARangedAttacker {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/nethengeic_wither.png");
    private static final DataParameter<Integer> FIRST_HEAD_TARGET = EntityDataManager.func_187226_a(EntityNethengeicWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> SECOND_HEAD_TARGET = EntityDataManager.func_187226_a(EntityNethengeicWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> THIRD_HEAD_TARGET = EntityDataManager.func_187226_a(EntityNethengeicWither.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer>[] HEAD_TARGETS = new DataParameter[]{FIRST_HEAD_TARGET, SECOND_HEAD_TARGET, THIRD_HEAD_TARGET};
    private final float[] xRotationHeads = new float[2];
    private final float[] yRotationHeads = new float[2];
    private final float[] xRotOHeads = new float[2];
    private final float[] yRotOHeads = new float[2];
    private final int[] nextHeadUpdate = new int[2];
    private final int[] idleHeadUpdates = new int[2];
    private final TreeSet<Enums.MobProperties> mobProperties = new TreeSet();
    public static final float entityWidth = 1.3f;
    private int attackCooldown = 45;

    public EntityNethengeicWither(World world) {
        super(world);
        this.func_70105_a(1.3f, 3.28125f);
        this.mobProperties.add(Enums.MobProperties.FIRE_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.EXPLOSION_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.MAGIC_IMMUNE);
        this.field_70178_ae = true;
        ((PathNavigateGround)this.func_70661_as()).func_179693_d(true);
    }

    public float func_70047_e() {
        return 2.484375f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackRanged((IRangedAttackMob)this, 1.0, 1, 50.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, false, false, PredicateUtil.NOT_UNDEAD));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIFindEntityNearestPlayer((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(1100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.32);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(52.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FIRST_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(SECOND_HEAD_TARGET, (Object)0);
        this.field_70180_af.func_187214_a(THIRD_HEAD_TARGET, (Object)0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobNethengeicWitherLiving;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobNethengeicWitherDeath;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundsRegister.mobNethengeicWitherHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityNethengeicWither;
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        int i;
        Entity target;
        this.field_70181_x *= 0.6;
        if (!this.field_70170_p.field_72995_K && this.getWatchedTargetId(0) > 0 && (target = this.field_70170_p.func_73045_a(this.getWatchedTargetId(0))) != null) {
            double distanceZ;
            double distanceX;
            double distanceSq;
            if (this.field_70163_u < target.field_70163_u + 5.0) {
                if (this.field_70181_x < 0.0) {
                    this.field_70181_x = 0.0;
                }
                this.field_70181_x += (0.5 - this.field_70181_x) * 0.6;
            }
            if ((distanceSq = (distanceX = target.field_70165_t - this.field_70165_t) * distanceX + (distanceZ = target.field_70161_v - this.field_70161_v) * distanceZ) > 9.0) {
                double distance = MathHelper.func_76133_a((double)distanceSq);
                this.field_70159_w += (distanceX / distance * 0.5 - this.field_70159_w) * 0.6;
                this.field_70179_y += (distanceZ / distance * 0.5 - this.field_70179_y) * 0.6;
            }
        }
        if (this.field_70159_w * this.field_70159_w * this.field_70179_y * this.field_70179_y > 0.05) {
            this.field_70177_z = (float)MathHelper.func_181159_b((double)this.field_70179_y, (double)this.field_70159_w) * 57.295776f - 90.0f;
        }
        super.func_70636_d();
        for (i = 0; i < 2; ++i) {
            this.yRotOHeads[i] = this.yRotationHeads[i];
            this.xRotOHeads[i] = this.xRotationHeads[i];
        }
        for (i = 0; i < 2; ++i) {
            Entity target2;
            int nextTargetId = this.getWatchedTargetId(i + 1);
            Entity entity = target2 = nextTargetId > 0 ? this.field_70170_p.func_73045_a(nextTargetId) : null;
            if (target2 != null) {
                double nextHeadX = this.getHeadX(i + 1);
                double nextHeadY = this.getHeadY(i + 1);
                double nextHeadZ = this.getHeadZ(i + 1);
                double distanceX = target2.field_70165_t - nextHeadX;
                double distanceY = target2.field_70163_u + (double)target2.func_70047_e() - nextHeadY;
                double distanceZ = target2.field_70161_v - nextHeadZ;
                double distance = MathHelper.func_76133_a((double)(distanceX * distanceX + distanceZ * distanceZ));
                float yRotation = (float)MathHelper.func_181159_b((double)distanceZ, (double)distanceX) * 57.295776f - 90.0f;
                float xRotation = (float)(-MathHelper.func_181159_b((double)distanceY, (double)distance) * 176.85840734641022);
                this.xRotationHeads[i] = this.clampRotation(this.xRotationHeads[i], xRotation, 40.0f);
                this.yRotationHeads[i] = this.clampRotation(this.yRotationHeads[i], yRotation, 10.0f);
                continue;
            }
            this.yRotationHeads[i] = this.clampRotation(this.yRotationHeads[i], this.field_70761_aq, 10.0f);
        }
        for (i = 0; i < 3; ++i) {
            double nextHeadX = this.getHeadX(i);
            double nextHeadY = this.getHeadY(i);
            double nextHeadZ = this.getHeadZ(i);
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, nextHeadX - this.field_70146_Z.nextGaussian() * 0.3, nextHeadY + this.field_70146_Z.nextGaussian() * 0.3, nextHeadZ + this.field_70146_Z.nextGaussian() * 0.3, 0.0, 0.0, 0.0, new int[0]);
        }
        if (this.getStage() > 1 && this.func_110143_aJ() > 0.0f) {
            this.func_70691_i(0.3f);
        }
    }

    protected void func_70619_bc() {
        super.func_70619_bc();
        block0: for (int i = 1; i < 3; ++i) {
            int targetId;
            if (this.field_70173_aa < this.nextHeadUpdate[i - 1]) continue;
            this.nextHeadUpdate[i - 1] = this.field_70173_aa + 10 + this.field_70146_Z.nextInt(10);
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL || this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                int head = i - 1;
                int headUpdateTime = this.idleHeadUpdates[head];
                this.idleHeadUpdates[head] = this.idleHeadUpdates[head] + 1;
                if (headUpdateTime > 15) {
                    double randPosX = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70165_t - 10.0), (double)(this.field_70165_t + 10.0));
                    double randPosY = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70163_u - 5.0), (double)(this.field_70163_u + 5.0));
                    double randPosZ = MathHelper.func_82716_a((Random)this.field_70146_Z, (double)(this.field_70161_v - 10.0), (double)(this.field_70161_v + 10.0));
                    this.idleHeadUpdates[head] = 0;
                    this.shootAtBlockPos(i + 1, randPosX, randPosY, randPosZ);
                }
            }
            if ((targetId = this.getWatchedTargetId(i)) > 0) {
                Entity target = this.field_70170_p.func_73045_a(targetId);
                if (target != null && target.func_70089_S() && target.func_70068_e(target) <= 900.0 && this.func_70685_l(target)) {
                    if (target instanceof EntityPlayer && ((EntityPlayer)target).field_71075_bZ.field_75102_a) {
                        this.setWatchedTargetId(i, 0);
                        continue;
                    }
                    this.shootAtTarget(i + 1, (EntityLivingBase)target);
                    this.nextHeadUpdate[i - 1] = this.field_70173_aa + 40 + this.field_70146_Z.nextInt(20);
                    this.idleHeadUpdates[i - 1] = 0;
                    continue;
                }
                this.setWatchedTargetId(i, 0);
                continue;
            }
            List targetList = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(20.0, 8.0, 20.0), entity -> !entity.func_70662_br());
            for (int j = 0; j < 10 && !targetList.isEmpty(); ++j) {
                EntityLivingBase target = (EntityLivingBase)targetList.get(this.field_70146_Z.nextInt(targetList.size()));
                if (target != this && target.func_70089_S() && this.func_70685_l((Entity)target)) {
                    if (target instanceof EntityPlayer) {
                        if (((EntityPlayer)target).field_71075_bZ.field_75102_a) continue block0;
                        this.setWatchedTargetId(i, target.func_145782_y());
                        continue block0;
                    }
                    this.setWatchedTargetId(i, target.func_145782_y());
                    continue block0;
                }
                targetList.remove(target);
            }
        }
        if (this.func_70638_az() != null) {
            this.setWatchedTargetId(0, this.func_70638_az().func_145782_y());
        } else {
            this.setWatchedTargetId(0, 0);
        }
    }

    public void func_70110_aj() {
    }

    private double getHeadX(int head) {
        if (head <= 0) {
            return this.field_70165_t;
        }
        return this.field_70165_t + (double)MathHelper.func_76134_b((float)((this.field_70761_aq + (float)(180 * (head - 1))) * ((float)Math.PI / 180))) * 1.3;
    }

    private double getHeadY(int head) {
        return this.field_70163_u + 3.0;
    }

    private double getHeadZ(int head) {
        if (head <= 0) {
            return this.field_70161_v;
        }
        return this.field_70165_t + (double)MathHelper.func_76126_a((float)((this.field_70761_aq + (float)(180 * (head - 1))) * ((float)Math.PI / 180))) * 1.3;
    }

    private float clampRotation(float xRotationOld, float xRotationNew, float max) {
        float degrees = MathHelper.func_76142_g((float)(xRotationNew - xRotationOld));
        return xRotationOld + MathHelper.func_76131_a((float)degrees, (float)(-max), (float)max);
    }

    private void shootAtBlockPos(int head, double posX, double posY, double posZ) {
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        } else {
            this.attackCooldown = this.getAttackCooldown();
            EntityNethengeicWitherShot projectile = new EntityNethengeicWitherShot(this, this.getStage() == 3);
            double distanceFactorX = posX - projectile.field_70165_t;
            double distanceFactorY = posY - projectile.field_70163_u;
            double distanceFactorZ = posZ - projectile.field_70161_v;
            double hyp = (double)MathHelper.func_76133_a((double)(distanceFactorX * distanceFactorX + distanceFactorZ * distanceFactorZ)) * 0.05;
            projectile.func_70186_c(distanceFactorX, distanceFactorY + hyp, distanceFactorZ, 1.6f, 4 - this.field_70170_p.func_175659_aa().func_151525_a());
            this.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public int getStage() {
        if (this.func_110143_aJ() > 550.0f) {
            return 1;
        }
        if (this.func_110143_aJ() > 220.0f) {
            return 2;
        }
        return 3;
    }

    private int getAttackCooldown() {
        switch (this.getStage()) {
            default: {
                return 45;
            }
            case 2: {
                return 20;
            }
            case 3: 
        }
        return 7;
    }

    private void shootAtTarget(int head, EntityLivingBase target) {
        this.shootAtBlockPos(head, target.field_70165_t, target.field_70163_u + (double)target.func_70047_e() + 0.5, target.field_70161_v);
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.shootAtTarget(0, target);
    }

    public void func_184724_a(boolean swingingArms) {
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicNethengeicWither;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_180427_aV() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source.func_76346_g() instanceof EntityNethengeicWither || EntityUtil.isMagicDamage(source, (Entity)this, 1.0f) || source.func_94541_c() || source.func_76347_k() || super.func_180431_b(source);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadYRotation(int head) {
        return this.yRotationHeads[head];
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadXRotation(int head) {
        return this.xRotationHeads[head];
    }

    public int getWatchedTargetId(int head) {
        return (Integer)this.field_70180_af.func_187225_a(HEAD_TARGETS[head]);
    }

    public void setWatchedTargetId(int head, int entityId) {
        this.field_70180_af.func_187227_b(HEAD_TARGETS[head], (Object)entityId);
    }

    protected boolean func_184228_n(Entity entityIn) {
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.nethengeicWither.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    public void doProjectileEntityImpact(BaseMobProjectile projectile, Entity target) {
        DamageSource damageSource = DamageSource.func_188403_a((Entity)projectile, (EntityLivingBase)this);
        float f = projectile instanceof EntityNethengeicWitherShot ? (((EntityNethengeicWitherShot)projectile).cataclysmic ? 30.0f : 20.0f) : 20.0f;
        if (target.func_70097_a(damageSource, f)) {
            this.doProjectileImpactEffect(projectile, target);
        }
    }

    @Override
    public void doProjectileBlockImpact(BaseMobProjectile projectile, IBlockState blockHit, BlockPos pos, EnumFacing sideHit) {
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }

    @Override
    public void doProjectileImpactEffect(BaseMobProjectile projectile, Entity target) {
        if (target instanceof EntityLivingBase && projectile instanceof EntityNethengeicWitherShot) {
            if (((EntityNethengeicWitherShot)projectile).cataclysmic) {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 70, 2, true, true));
            } else {
                ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_82731_v, 90, 1, true, true));
            }
        }
        WorldUtil.createExplosion((Entity)this, this.field_70170_p, (Entity)projectile, 2.0f);
    }
}

