/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.primordialfive;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.primordialfive.EntityRaxxan;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.StringUtil;

public class EntityOkazor
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/okazor.png");
    public static final float entityWidth = 0.7f;
    private int healCountdown = 0;
    private int healCounter = 0;

    public EntityOkazor(EntityRaxxan raxxan) {
        this(raxxan.field_70170_p);
        this.func_70012_b(raxxan.field_70165_t, raxxan.field_70163_u, raxxan.field_70161_v, raxxan.field_70177_z, raxxan.field_70125_A);
    }

    public EntityOkazor(World world) {
        super(world, 0.7f, 2.375f);
    }

    public float func_70047_e() {
        return 2.009375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 1200.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 50.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobPrimordialLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobPrimordialDeath;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityOkazor;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            if (this.healCountdown > 0) {
                --this.healCountdown;
            } else {
                this.healCounter = 0;
            }
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (!this.field_70170_p.field_72995_K) {
            ++this.healCounter;
            this.healCountdown = 80;
            if (this.healCounter == 3) {
                this.func_70691_i(this.func_110138_aP());
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.primordialFive.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicPrimordialFive;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

