/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.smash;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.advent.AdventOfAscension;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.StringUtil;

public class EntitySmash
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/smash.png");
    public static final float entityWidth = 0.8f;

    public EntitySmash(World world) {
        super(world, 0.8f, 2.6f);
        this.setSlipperyMovement();
        this.func_70659_e(2.1f);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobSmashLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobSmashDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobSmashHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.heavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entitySmash;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.9;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.329;
    }

    public float func_70047_e() {
        return 2.35f;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        float percentHealth;
        if (target instanceof EntityLivingBase && (percentHealth = EntityUtil.getCurrentHealthPercent((EntityLivingBase)this)) > 0.0f) {
            double resist = 1.0;
            IAttributeInstance attrib = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
            if (attrib != null) {
                resist -= attrib.func_111126_e();
            }
            if (percentHealth <= 20.0f) {
                target.func_70024_g(this.field_70159_w * 5.2 * resist, 3.5 * resist, this.field_70179_y * 5.2 * resist);
            } else if (percentHealth <= 40.0f) {
                target.func_70024_g(this.field_70159_w * 5.8 * resist, 3.0 * resist, this.field_70179_y * 5.8 * resist);
            } else if (percentHealth <= 60.0f) {
                target.func_70024_g(this.field_70159_w * 5.4 * resist, 2.5 * resist, this.field_70179_y * 5.4 * resist);
            } else if (percentHealth <= 80.0f) {
                target.func_70024_g(this.field_70159_w * 5.0 * resist, 2.0 * resist, this.field_70179_y * 5.0 * resist);
            }
            target.field_70133_I = true;
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.smash.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        } else if (this.getBossMusic() != null) {
            AdventOfAscension.proxy.stopMusic();
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    @Nonnull
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicSmash;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

