/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.boss.vinocorne;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.boss.vinocorne.EntityBlueFlower;
import net.tslat.aoa3.entity.boss.vinocorne.EntityGreenFlower;
import net.tslat.aoa3.entity.boss.vinocorne.EntityOrangeFlower;
import net.tslat.aoa3.entity.boss.vinocorne.EntityPurpleFlower;
import net.tslat.aoa3.entity.boss.vinocorne.EntityYellowFlower;
import net.tslat.aoa3.entity.properties.BossEntity;
import net.tslat.aoa3.utils.StringUtil;

public class EntityVinocorne
extends AoAMeleeMob
implements BossEntity {
    private static final ResourceLocation bossBarTexture = new ResourceLocation("aoa3", "textures/gui/bossbars/vinocorne.png");
    public static final float entityWidth = 1.2f;
    private int minionCountdown = 70;

    public EntityVinocorne(World world) {
        super(world, 1.2f, 3.0f);
    }

    public float func_70047_e() {
        return 2.28125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.8;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 2500.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 10.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobTreeSpiritLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobTreeSpiritDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobTreeSpiritHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityVinocorne;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K && this.field_70173_aa == 1) {
            this.playMusic((Entity)this);
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70128_L) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.minionCountdown > 0) {
                --this.minionCountdown;
            }
            if (this.minionCountdown == 0) {
                this.minionCountdown = 70;
                switch (this.field_70146_Z.nextInt(5)) {
                    case 0: {
                        this.field_70170_p.func_72838_d((Entity)new EntityBlueFlower(this));
                        break;
                    }
                    case 1: {
                        this.field_70170_p.func_72838_d((Entity)new EntityYellowFlower(this));
                        break;
                    }
                    case 2: {
                        this.field_70170_p.func_72838_d((Entity)new EntityOrangeFlower(this));
                        break;
                    }
                    case 3: {
                        this.field_70170_p.func_72838_d((Entity)new EntityGreenFlower(this));
                        break;
                    }
                    case 4: {
                        this.field_70170_p.func_72838_d((Entity)new EntityPurpleFlower(this));
                    }
                }
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                StringUtil.sendMessageWithinRadius(StringUtil.getLocaleWithArguments("message.mob.vinocorne.kill", killer.getDisplayNameString()), (Entity)this, 50);
            }
        }
    }

    public boolean func_184205_a(Entity entity, boolean force) {
        return false;
    }

    @Override
    public ResourceLocation getBossBarTexture() {
        return bossBarTexture;
    }

    @Override
    @Nullable
    public SoundEvent getBossMusic() {
        return SoundsRegister.musicVinocorne;
    }

    public void func_70624_b(@Nullable EntityLivingBase target) {
        if (target instanceof BossEntity) {
            return;
        }
        super.func_70624_b(target);
    }
}

