/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.minions;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityFriendlyCreeper
extends AoAMinion {
    public static final float entityWidth = 0.6f;
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityFriendlyCreeper.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(EntityFriendlyCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(EntityFriendlyCreeper.class, (DataSerializer)DataSerializers.field_187198_h);
    private int lastActiveTime;
    private int timeSinceIgnited;
    private int fuseTime = 20;
    private float explosionRadius = 2.2f;

    public EntityFriendlyCreeper(World world) {
        super(world, -1, 0.6f, 1.7f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFriendlyCreeperSwell(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityMob.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityMob.class, true));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(0.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(8.0);
    }

    @Override
    protected double getBaseMaxHealth() {
        return 20.0;
    }

    @Override
    protected boolean isHostile() {
        return true;
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)this.func_110143_aJ() - 1;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        super.func_180430_e(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("powered", true);
        }
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74774_a("ExplosionRadius", (byte)this.explosionRadius);
        compound.func_74757_a("ignited", this.hasIgnited());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("powered"));
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74771_c("ExplosionRadius");
        }
        if (compound.func_74767_n("ignited")) {
            this.ignite();
        }
    }

    @Override
    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int state;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((state = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.timeSinceIgnited += state;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
        }
        super.func_70071_h_();
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187570_aq;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187568_ap;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        return true;
    }

    public boolean getPowered() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    @SideOnly(value=Side.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return ((float)this.lastActiveTime + (float)(this.timeSinceIgnited - this.lastActiveTime) * partialTicks) / (float)(this.fuseTime - 2);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public void func_70077_a(EntityLightningBolt lightningBolt) {
        super.func_70077_a(lightningBolt);
        this.field_70180_af.func_187227_b(POWERED, (Object)true);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_77973_b() instanceof ItemFlintAndSteel) {
            this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.ignite();
                heldStack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        return super.func_184645_a(player, hand);
    }

    public void explode() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72876_a((Entity)this.func_70902_q(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.explosionRadius, WorldUtil.checkGameRule(this.field_70170_p, "doStrongerMobGriefing"));
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    private void spawnLingeringCloud() {
        Collection activeEffects = this.func_70651_bq();
        if (!activeEffects.isEmpty()) {
            EntityAreaEffectCloud entityEffectCloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            entityEffectCloud.func_184483_a(2.5f);
            entityEffectCloud.func_184495_b(-0.5f);
            entityEffectCloud.func_184485_d(10);
            entityEffectCloud.func_184486_b(entityEffectCloud.func_184489_o() / 2);
            entityEffectCloud.func_184487_c(-entityEffectCloud.func_184490_j() / (float)entityEffectCloud.func_184489_o());
            for (PotionEffect effect : activeEffects) {
                entityEffectCloud.func_184496_a(new PotionEffect(effect));
            }
            this.field_70170_p.func_72838_d((Entity)entityEffectCloud);
        }
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    private class EntityAIFriendlyCreeperSwell
    extends EntityAIBase {
        EntityFriendlyCreeper swellingCreeper;
        EntityLivingBase target;

        public EntityAIFriendlyCreeperSwell(EntityFriendlyCreeper creeper) {
            this.swellingCreeper = creeper;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            EntityLivingBase target = this.swellingCreeper.func_70638_az();
            return this.swellingCreeper.getCreeperState() > 0 || target != null && this.swellingCreeper.func_70068_e((Entity)target) < 9.0;
        }

        public void func_75249_e() {
            this.swellingCreeper.func_70661_as().func_75499_g();
            this.target = this.swellingCreeper.func_70638_az();
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null || this.swellingCreeper.func_70068_e((Entity)this.target) > 49.0 || !this.swellingCreeper.func_70635_at().func_75522_a((Entity)this.target)) {
                this.swellingCreeper.setCreeperState(-1);
            } else {
                this.swellingCreeper.setCreeperState(1);
            }
        }
    }
}

