/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.misc;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.tslat.aoa3.common.registration.BlockRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.utils.LootUtil;
import net.tslat.aoa3.utils.ModUtil;

public class EntityLottoTotem
extends Entity {
    public static final float entityWidth = 0.75f;
    private UUID winnerUUID = null;
    private UUID ownerUUID = null;

    public EntityLottoTotem(World world, BlockPos pos, UUID winnerUUID, UUID ownerUUID) {
        this(world);
        this.winnerUUID = winnerUUID;
        this.ownerUUID = ownerUUID;
        AxisAlignedBB floorBoundingBox = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos).func_185890_d((IBlockAccess)world, pos);
        this.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + (floorBoundingBox == null ? 0.0 : floorBoundingBox.field_72337_e), (double)pos.func_177952_p() + 0.5);
    }

    public EntityLottoTotem(World world) {
        super(world);
        this.field_70156_m = true;
        this.func_70105_a(0.75f, 0.95f);
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        return this.field_70173_aa >= 12000 || !this.field_70170_p.field_72995_K && (this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID));
    }

    public EnumActionResult func_184199_a(EntityPlayer player, Vec3d vec, EnumHand hand) {
        if (!this.field_70128_L && (this.ownerUUID == null || player.func_110124_au().equals(this.ownerUUID))) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.winnerUUID != null && this.winnerUUID.equals(this.func_110124_au())) {
                    for (ItemStack stack : LootUtil.generateLootWithCustomLuck(LootSystemRegister.lottoTotem, (WorldServer)this.field_70170_p, 5.0f)) {
                        EntityItem drop = this.func_70099_a(stack, 0.0f);
                        if (drop != null) {
                            drop.func_145797_a(player.func_70005_c_());
                        }
                        ModUtil.completeAdvancement((EntityPlayerMP)player, "overworld/winner_winner", "lotto_win");
                    }
                    EntityItem drop = this.func_70099_a(new ItemStack((Block)BlockRegister.bannerLotto), 0.0f);
                    if (drop != null) {
                        drop.func_145797_a(player.func_70005_c_());
                    }
                    this.field_70170_p.func_184133_a(null, this.func_180425_c(), SoundsRegister.lottoWin, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                for (EntityLottoTotem totem : this.field_70170_p.func_72872_a(EntityLottoTotem.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(2.0))) {
                    totem.func_70106_y();
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.field_70170_p.field_72995_K && this.field_70128_L) {
            for (int i = 0; i < 3; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t, this.field_70163_u + 0.3, this.field_70161_v, 0.0, 0.1, 0.0, new int[0]);
            }
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound compound) {
        if (this.winnerUUID != null) {
            compound.func_186854_a("WinningUUID", this.winnerUUID);
        }
        if (this.ownerUUID != null) {
            compound.func_186854_a("OwnerUUID", this.ownerUUID);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        if (compound.func_186855_b("WinningUUID")) {
            this.winnerUUID = compound.func_186857_a("WinningUUID");
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.ownerUUID = compound.func_186857_a("OwnerUUID");
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_96092_aw() {
        return false;
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_180431_b(DamageSource source) {
        return source != DamageSource.field_76380_i;
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
    }

    public void func_70071_h_() {
    }
}

