/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.barathos;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityArkback
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 3.8f;

    public EntityArkback(World world) {
        super(world, 3.8f, 3.0f);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.GUN_IMMUNE);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public float func_70047_e() {
        return 2.4375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 200.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 14.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.23;
    }

    @Override
    protected double getBaseArmour() {
        return 6.0;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobArkbackLiving;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobArkbackDeath;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobArkbackHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.veryHeavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityArkback;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isGunDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

