/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.creeponia;

import java.util.Collection;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAICreeperSwell;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.entity.minions.AoAMinion;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.WorldUtil;

public abstract class EntityCreeponiaCreeper
extends EntityCreeper {
    protected final TreeSet<Enums.MobProperties> mobProperties = this instanceof SpecialPropertyEntity ? new TreeSet() : null;
    protected int field_82225_f = 30;
    protected int field_70834_e;
    protected int field_70833_d;

    public EntityCreeponiaCreeper(World world, float entityWidth, float entityHeight) {
        super(world);
        this.field_70728_aV = (int)(this.getBaseMaxHealth() / 10.0);
        this.func_70105_a(entityWidth, entityHeight);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAICreeperSwell((EntityCreeper)this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityOcelot.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, AoAMinion.class, 10, true, false, EntityTameable::func_70909_n));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.getBaseMaxHealth());
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(this.getBaseKnockbackResistance());
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(this.getBaseMovementSpeed());
    }

    protected abstract double getBaseKnockbackResistance();

    protected abstract double getBaseMaxHealth();

    protected abstract double getBaseMovementSpeed();

    public abstract float getExplosionStrength();

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.func_184647_J() != null) {
            LootTable lootTable = this.field_70170_p.func_184146_ak().func_186521_a(this.func_184647_J());
            LootContext.Builder lootBuilder = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186473_a(source);
            if (wasRecentlyHit && this.field_70717_bb != null) {
                lootBuilder.func_186470_a(this.field_70717_bb).func_186469_a(this.field_70717_bb.func_184817_da() + (float)lootingModifier);
            }
            for (ItemStack stack : lootTable.func_186462_a(this.field_70146_Z, lootBuilder.func_186471_a())) {
                this.func_70099_a(stack, 0.0f);
            }
            this.func_82160_b(wasRecentlyHit, lootingModifier);
        } else {
            super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        }
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int stateValue;
            this.field_70834_e = this.field_70833_d;
            if (this.func_146078_ca()) {
                this.func_70829_a(1);
            }
            if ((stateValue = this.func_70832_p()) > 0 && this.field_70833_d == 0) {
                this.func_184185_a(SoundEvents.field_187572_ar, 1.0f, 0.5f);
            }
            this.field_70833_d += stateValue;
            if (this.field_70833_d < 0) {
                this.field_70833_d = 0;
            }
            if (this.field_70833_d >= this.field_82225_f) {
                this.field_70833_d = this.field_82225_f;
                this.func_146077_cc();
            }
        }
        if (ForgeHooks.onLivingUpdate((EntityLivingBase)this)) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            int arrowCount = this.func_85035_bI();
            if (arrowCount > 0) {
                if (this.field_70720_be <= 0) {
                    this.field_70720_be = 20 * (30 - arrowCount);
                }
                --this.field_70720_be;
                if (this.field_70720_be <= 0) {
                    this.func_85034_r(arrowCount - 1);
                }
            }
            if (this.field_70173_aa % 20 == 0) {
                this.func_110142_aN().func_94549_h();
            }
            if (!this.field_184238_ar) {
                boolean flag = this.func_70644_a(MobEffects.field_188423_x);
                if (this.func_70083_f(6) != flag) {
                    this.func_70052_a(6, flag);
                }
            }
        }
        this.func_70636_d();
        double interpolateX = this.field_70165_t - this.field_70169_q;
        double interpolateZ = this.field_70161_v - this.field_70166_s;
        float interpolateLatSq = (float)(interpolateX * interpolateX + interpolateZ * interpolateZ);
        float interpolateRenderYaw = this.field_70761_aq;
        float moveDistance = 0.0f;
        this.field_70768_au = this.field_110154_aX;
        float frictionFactor = 0.0f;
        if (interpolateLatSq > 0.0025000002f) {
            frictionFactor = 1.0f;
            moveDistance = (float)Math.sqrt(interpolateLatSq) * 3.0f;
            float updatedInterpolYaw = (float)MathHelper.func_181159_b((double)interpolateZ, (double)interpolateX) * 57.295776f - 90.0f;
            float absoluteWrappedYaw = MathHelper.func_76135_e((float)(MathHelper.func_76142_g((float)this.field_70177_z) - updatedInterpolYaw));
            interpolateRenderYaw = 95.0f < absoluteWrappedYaw && absoluteWrappedYaw < 265.0f ? updatedInterpolYaw - 180.0f : updatedInterpolYaw;
        }
        if (this.field_70733_aJ > 0.0f) {
            interpolateRenderYaw = this.field_70177_z;
        }
        if (!this.field_70122_E) {
            frictionFactor = 0.0f;
        }
        this.field_110154_aX += (frictionFactor - this.field_110154_aX) * 0.3f;
        this.field_70170_p.field_72984_F.func_76320_a("headTurn");
        moveDistance = this.func_110146_f(interpolateRenderYaw, moveDistance);
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70170_p.field_72984_F.func_76320_a("rangeChecks");
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar < -180.0f) {
            this.field_70760_ar -= 360.0f;
        }
        while (this.field_70761_aq - this.field_70760_ar >= 180.0f) {
            this.field_70760_ar += 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at < -180.0f) {
            this.field_70758_at -= 360.0f;
        }
        while (this.field_70759_as - this.field_70758_at >= 180.0f) {
            this.field_70758_at += 360.0f;
        }
        this.field_70170_p.field_72984_F.func_76319_b();
        this.field_70764_aw += moveDistance;
        if (!this.field_70170_p.field_72995_K) {
            this.func_110159_bB();
            if (this.field_70173_aa % 5 == 0) {
                boolean inControl = !(this.func_184179_bs() instanceof EntityLiving);
                this.field_70714_bg.func_188527_a(1, inControl);
                this.field_70714_bg.func_188527_a(4, inControl && !(this.func_184187_bx() instanceof EntityBoat));
                this.field_70714_bg.func_188527_a(2, inControl);
            }
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.func_70106_y();
            }
        }
    }

    public boolean func_180431_b(DamageSource source) {
        if (source == DamageSource.field_76380_i) {
            return false;
        }
        if (this.func_190530_aW()) {
            return true;
        }
        return this.isSpecialImmuneTo(source, 1);
    }

    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return false;
    }

    protected boolean func_70814_o() {
        return WorldUtil.getLightLevel(this.field_70170_p, this.func_180425_c(), true, false) <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70601_bi() {
        return this.field_70170_p.func_175659_aa() != EnumDifficulty.PEACEFUL && (double)this.field_70146_Z.nextFloat() < 0.1 && this.func_70814_o() && this.canSpawnOnBlock(this.field_70170_p.func_180495_p(this.func_180425_c().func_177977_b()));
    }

    protected boolean canSpawnOnBlock(IBlockState block) {
        return block.func_189884_a((Entity)this);
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70831_j(float partialTicks) {
        return ((float)this.field_70834_e + (float)(this.field_70833_d - this.field_70834_e) * partialTicks) / (float)(this.field_82225_f - 2);
    }

    protected void func_146077_cc() {
        if (!this.field_70170_p.field_72995_K) {
            WorldUtil.createExplosion((Entity)this, this.field_70170_p, this.getExplosionStrength() * (this.func_70830_n() ? 2.0f : 1.0f));
            this.func_70106_y();
            this.func_190741_do();
        }
    }

    protected void func_190741_do() {
        Collection activeEffects = this.func_70651_bq();
        if (!activeEffects.isEmpty()) {
            EntityAreaEffectCloud effectCloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            effectCloud.func_184483_a(2.5f);
            effectCloud.func_184495_b(-0.5f);
            effectCloud.func_184485_d(10);
            effectCloud.func_184486_b(effectCloud.func_184489_o() / 2);
            effectCloud.func_184487_c(-effectCloud.func_184490_j() / (float)effectCloud.func_184489_o());
            for (PotionEffect effect : activeEffects) {
                effectCloud.func_184496_a(new PotionEffect(effect));
            }
            this.field_70170_p.func_72838_d((Entity)effectCloud);
        }
    }
}

