/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.haven;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.DimensionRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityAngelica
extends AoAFlyingMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;

    public EntityAngelica(World world) {
        super(world, 0.6f, 2.0f);
        this.mobProperties.add(Enums.MobProperties.STATUS_IMMUNE);
    }

    public float func_70047_e() {
        return 1.75f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 84.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 1.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobAngelicaLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobAngelicaDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobAngelicaHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.field_70170_p.field_73011_w.func_186058_p() == DimensionRegister.dimensionAncientCavern ? null : LootSystemRegister.entityAngelica;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_184603_cC() {
        return false;
    }

    public void func_70690_d(PotionEffect effect) {
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.ancientCavern) {
            Entity source = cause.func_76346_g();
            EntityPlayer killer = null;
            if (source != null) {
                if (source instanceof EntityPlayer) {
                    killer = (EntityPlayer)source;
                } else if (source instanceof EntityTameable && ((EntityTameable)source).func_70902_q() instanceof EntityPlayer) {
                    killer = (EntityPlayer)((EntityTameable)source).func_70902_q();
                }
            }
            if (killer != null) {
                PlayerUtil.addTributeToPlayer(killer, Enums.Deities.LUXON, 8);
            }
        }
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 60, 1, true, false));
            this.func_70690_d(new PotionEffect(MobEffects.field_188424_y, 60, 0, true, false));
            ((EntityLivingBase)target).func_70690_d(new PotionEffect(MobEffects.field_188424_y, 60, 0, true, true));
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

