/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.immortallis;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntitySkeledon
extends AoAMeleeMob {
    public static final float entityWidth = 0.625f;
    private int cloakCooldown = 80;

    public EntitySkeledon(World world) {
        super(world, 0.625f, 1.3125f);
    }

    public float func_70047_e() {
        return 1.1875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 120.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 11.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187854_fc;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187856_fd;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187864_fh;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public void func_70636_d() {
        super.func_70636_d();
        --this.cloakCooldown;
        if (this.cloakCooldown == 0) {
            this.cloakCooldown = 80;
            this.field_70159_w *= 0.5;
            this.field_70179_y *= 0.5;
            this.func_70690_d(new PotionEffect(MobEffects.field_76441_p, 20, 0, false, true));
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.immortallis && ((attacker = cause.func_76346_g()) instanceof EntityPlayer || attacker instanceof EntityTameable)) {
            EntityPlayer pl = null;
            if (attacker instanceof EntityTameable) {
                if (((EntityTameable)attacker).func_70902_q() instanceof EntityPlayer) {
                    pl = (EntityPlayer)((EntityTameable)attacker).func_70902_q();
                }
            } else {
                pl = (EntityPlayer)attacker;
            }
            if (pl != null) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                if (plData.stats().getTribute(Enums.Deities.EREBON) < 100) {
                    plData.stats().addTribute(Enums.Deities.EREBON, Math.min(4, 100 - plData.stats().getTribute(Enums.Deities.EREBON)));
                }
                if (plData.stats().getTribute(Enums.Deities.EREBON) >= 100) {
                    plData.sendThrottledChatMessage("message.feedback.immortallisProgression.skeletalSpiritsEnd", new Object[0]);
                }
            }
        }
    }
}

