/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.immortallis;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.player.PlayerDataManager;
import net.tslat.aoa3.utils.player.PlayerUtil;

public class EntityVisage
extends AoAMeleeMob {
    public static final float entityWidth = 0.7f;
    private EntityVisage mirageHost = null;

    public EntityVisage(World world) {
        super(world, 0.7f, 1.5f);
    }

    public EntityVisage(World world, EntityVisage mirageHost) {
        super(world, 0.7f, 1.5f);
        this.mirageHost = mirageHost;
    }

    public float func_70047_e() {
        return 1.46875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 60.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 11.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.2875;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobPenumbraLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobPenumbraDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobPenumbraHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return null;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.mirageHost != null) {
            this.func_70106_y();
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            if (this.mirageHost != null) {
                if (this.field_70173_aa >= 600 || this.mirageHost.field_70128_L) {
                    this.func_70106_y();
                }
            } else if (this.field_70146_Z.nextInt(200) == 0) {
                EntityVisage visage = new EntityVisage(this.field_70170_p, this);
                double xPos = this.field_70165_t + (double)((int)(this.field_70146_Z.nextFloat() * 10.0f - 5.0f));
                double zPos = this.field_70161_v + (double)((int)(this.field_70146_Z.nextFloat() * 10.0f - 5.0f));
                double yPos = this.field_70170_p.func_189649_b((int)xPos, (int)zPos);
                visage.func_70107_b(xPos, yPos, zPos);
                this.field_70170_p.func_72838_d((Entity)visage);
            }
        }
    }

    public void func_70645_a(DamageSource cause) {
        Entity attacker;
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.immortallis && ((attacker = cause.func_76346_g()) instanceof EntityPlayer || attacker instanceof EntityTameable)) {
            EntityPlayer pl = null;
            if (attacker instanceof EntityTameable) {
                if (((EntityTameable)attacker).func_70902_q() instanceof EntityPlayer) {
                    pl = (EntityPlayer)((EntityTameable)attacker).func_70902_q();
                }
            } else {
                pl = (EntityPlayer)attacker;
            }
            if (pl != null) {
                PlayerDataManager plData = PlayerUtil.getAdventPlayer(pl);
                plData.stats().addTribute(Enums.Deities.EREBON, 4);
                if (plData.stats().getTribute(Enums.Deities.EREBON) == 200) {
                    plData.sendThrottledChatMessage("message.feedback.immortallisProgression.evilSpiritsEnd", new Object[0]);
                }
            }
        }
    }
}

