/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.lelyetia;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAFlyingMeleeMob;
import net.tslat.aoa3.utils.ConfigurationUtil;
import net.tslat.aoa3.utils.EntityUtil;
import net.tslat.aoa3.utils.ItemUtil;

public class EntityFlye
extends AoAFlyingMeleeMob {
    public static final float entityWidth = 1.75f;
    private static final DataParameter<BlockPos> ALTAR_POS = EntityDataManager.func_187226_a(EntityFlye.class, (DataSerializer)DataSerializers.field_187200_j);
    private BlockPos altarPos = null;

    public EntityFlye(World world, BlockPos altarPos) {
        this(world);
        BlockPos spawnPos;
        this.field_70180_af.func_187227_b(ALTAR_POS, (Object)altarPos);
        while (world.func_180495_p(spawnPos = new BlockPos((double)altarPos.func_177958_n() + this.field_70146_Z.nextDouble() * 40.0 - 20.0, (double)altarPos.func_177956_o() + this.field_70146_Z.nextDouble() * 40.0 - 20.0, (double)altarPos.func_177952_p() + this.field_70146_Z.nextDouble() * 40.0 - 20.0)).func_185904_a().func_76230_c()) {
        }
        this.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        this.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 9999999, 0, true, false));
    }

    public EntityFlye(World world) {
        super(world, 1.75f, 1.75f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ALTAR_POS, (Object)BlockPos.field_177992_a);
    }

    public float func_70047_e() {
        return 1.375f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.2f;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 50.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 6.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.1;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobFlyeLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobFlyeDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobFlyeHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityFlye;
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (key == ALTAR_POS) {
            this.altarPos = (BlockPos)this.field_70180_af.func_187225_a(ALTAR_POS);
            if (this.altarPos == BlockPos.field_177992_a) {
                this.altarPos = null;
            }
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.altarPos != null) {
            compound.func_74772_a("GrawAltarPos", this.altarPos.func_177986_g());
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("GrawAltarPos")) {
            this.altarPos = BlockPos.func_177969_a((long)compound.func_74763_f("GrawAltarPos"));
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K && this.altarPos != null && this.field_70170_p.func_82737_E() % 40L == 0L && this.altarPos.func_185332_f((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v) > 30.0) {
            double posX = ((float)this.altarPos.func_177958_n() + this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 10.0f;
            double posY = ((float)this.altarPos.func_177956_o() + this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 10.0f;
            double posZ = ((float)this.altarPos.func_177952_p() + this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 10.0f;
            this.func_70605_aq().func_75642_a(posX, posY, posZ, 1.0);
        }
    }

    @Nullable
    public BlockPos getGrawAltarPos() {
        return this.altarPos;
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70170_p.field_73011_w.getDimension() == ConfigurationUtil.MainConfig.dimensionIds.lelyetia && EntityUtil.isMeleeDamage(cause) && cause.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer pl = (EntityPlayer)cause.func_76346_g();
                if (pl.field_70163_u >= 100.0 && ItemUtil.consumeItem(pl, new ItemStack((Item)ItemRegister.realmstoneBlank))) {
                    ItemUtil.givePlayerItemOrDrop(pl, new ItemStack((Item)ItemRegister.realmstoneHaven));
                }
            }
            if (this.altarPos != null && this.field_70718_bc > 0) {
                this.func_70099_a(new ItemStack((Item)ItemRegister.guardiansEye), 0.0f);
            }
        }
    }
}

