/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.nether;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityInfernal
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 1.125f;

    public EntityInfernal(World world) {
        super(world, 1.125f, 1.875f);
        this.field_70178_ae = true;
        this.mobProperties.add(Enums.MobProperties.FIRE_IMMUNE);
    }

    public float func_70047_e() {
        return 1.71875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 1.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 95.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 8.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.25;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobInfernalLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobInfernalHit;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobInfernalHit;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.veryHeavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityInfernal;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return source.func_76347_k();
    }

    @Override
    protected void doMeleeEffect(Entity target) {
        if (target instanceof EntityLivingBase) {
            double resist = 1.0;
            IAttributeInstance attrib = ((EntityLivingBase)target).func_110148_a(SharedMonsterAttributes.field_111266_c);
            if (attrib != null) {
                resist -= attrib.func_111126_e();
            }
            target.func_70015_d(5);
            target.func_70024_g(this.field_70159_w * 10.5 * resist, this.field_70181_x * 0.5 * resist, this.field_70179_y * 10.5 * resist);
            target.field_70133_I = true;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean success = super.func_70097_a(source, amount);
        if (success && EntityUtil.isMeleeDamage(source)) {
            source.func_76346_g().func_70015_d(5);
        }
        return success;
    }

    @Override
    protected double getSpawnChanceFactor() {
        return 0.5;
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

