/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.runandor;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityPaladin
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6875f;

    public EntityPaladin(World world) {
        super(world, 0.6875f, 2.0f);
        this.mobProperties.add(Enums.MobProperties.MELEE_IMMUNE);
        this.mobProperties.add(Enums.MobProperties.RANGED_IMMUNE);
    }

    public float func_70047_e() {
        return 1.71875f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.2;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 109.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 16.0;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Override
    protected double getBaseArmour() {
        return 18.0;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187689_f;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187689_f;
    }

    @Override
    protected SoundEvent getStepSound() {
        return SoundsRegister.veryHeavyStep;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityPaladin;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isMeleeDamage(source) || EntityUtil.isRangedDamage(source, (Entity)this, damage);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

