/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.shyrelands;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoARangedMob;
import net.tslat.aoa3.entity.projectiles.mob.BaseMobProjectile;
import net.tslat.aoa3.entity.projectiles.mob.EntityShyreBeam;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityArcWizard
extends AoARangedMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;

    public EntityArcWizard(World world) {
        super(world, 0.6f, 2.3f);
        this.mobProperties.add(Enums.MobProperties.MAGIC_IMMUNE);
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.1;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 148.0;
    }

    @Override
    public double getBaseProjectileDamage() {
        return 16.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.207;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobArcWizardLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobArcWizardDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobArcWizardHit;
    }

    @Override
    @Nullable
    protected SoundEvent getShootSound() {
        return SoundsRegister.shotArcWizardFire;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityArcWizard;
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isMagicDamage(source, (Entity)this, damage);
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < 35.0 && super.func_70601_bi();
    }

    @Override
    protected BaseMobProjectile getNewProjectileInstance() {
        return new EntityShyreBeam(this, Enums.MobProjectileType.MAGIC);
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

