/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.mobs.shyrelands;

import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.tslat.aoa3.common.registration.LootSystemRegister;
import net.tslat.aoa3.common.registration.SoundsRegister;
import net.tslat.aoa3.entity.base.AoAMeleeMob;
import net.tslat.aoa3.entity.properties.SpecialPropertyEntity;
import net.tslat.aoa3.library.Enums;
import net.tslat.aoa3.utils.EntityUtil;

public class EntityStimulo
extends AoAMeleeMob
implements SpecialPropertyEntity {
    public static final float entityWidth = 0.6f;

    public EntityStimulo(World world) {
        super(world, 0.6f, 1.875f);
        this.mobProperties.add(Enums.MobProperties.BLASTER_IMMUNE);
    }

    public float func_70047_e() {
        return 1.78125f;
    }

    @Override
    protected double getBaseKnockbackResistance() {
        return 0.0;
    }

    @Override
    protected double getBaseMaxHealth() {
        return 164.0;
    }

    @Override
    protected double getBaseMeleeDamage() {
        return 15.5;
    }

    @Override
    protected double getBaseMovementSpeed() {
        return 0.27;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return SoundsRegister.mobStimuloLiving;
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundsRegister.mobStimuloDeath;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsRegister.mobStimuloHit;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootSystemRegister.entityStimulo;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70163_u < 35.0 && super.func_70601_bi();
    }

    @Override
    protected boolean isSpecialImmuneTo(DamageSource source, int damage) {
        return EntityUtil.isBlasterDamage(source);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K) {
            float healthPercent = EntityUtil.getCurrentHealthPercent((EntityLivingBase)this);
            if ((double)healthPercent < 0.25) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, -1, 0, true, false));
            } else if ((double)healthPercent < 0.5) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, -1, 1, true, false));
            } else if ((double)healthPercent < 0.75) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76424_c, -1, 2, true, false));
            }
        }
    }

    @Override
    @Nonnull
    public TreeSet<Enums.MobProperties> getMobProperties() {
        return this.mobProperties;
    }
}

