/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.arrow;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketChangeGameState;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tslat.aoa3.common.registration.ItemRegister;
import net.tslat.aoa3.entity.projectiles.HardProjectile;
import net.tslat.aoa3.entity.projectiles.gun.EntityHollyArrowShot;
import net.tslat.aoa3.item.weapon.bow.BaseBow;

public class EntityHollyArrow
extends EntityArrow
implements HardProjectile {
    private static final Predicate<Entity> ARROW_TARGETS = Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, Entity::func_70067_L});
    private static final DataParameter<Byte> CRITICAL = EntityDataManager.func_187226_a(EntityHollyArrow.class, (DataSerializer)DataSerializers.field_187191_a);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private boolean hasHitGround;
    public boolean field_70254_i;
    public int field_184552_b;
    public EntityArrow.PickupStatus field_70251_a = EntityArrow.PickupStatus.DISALLOWED;
    private int arrowShake;
    private Entity shooter;
    private int ticksInGround;
    private int ticksInAir;
    private double baseDamage = 10.0;
    private int knockbackStrength;
    private BaseBow bow;

    public EntityHollyArrow(World world) {
        super(world);
    }

    public EntityHollyArrow(World world, double x, double y, double z) {
        super(world);
        this.func_70107_b(x, y, z);
    }

    public EntityHollyArrow(World world, EntityHollyArrowShot archergunShot) {
        super(world);
        this.field_70250_c = this.shooter = archergunShot.func_85052_h();
        this.bow = null;
        this.baseDamage = 0.0;
        this.knockbackStrength = 0;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70080_a(archergunShot.field_70165_t, archergunShot.field_70163_u, archergunShot.field_70161_v, archergunShot.field_70177_z, archergunShot.field_70125_A);
        if (this.shooter instanceof EntityPlayer) {
            this.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
    }

    public EntityHollyArrow(World world, BaseBow bow, EntityLivingBase shooter, double damage) {
        super(world);
        this.shooter = shooter;
        this.field_70250_c = shooter;
        this.bow = bow;
        this.baseDamage = damage;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e() - (double)0.1f, shooter.field_70161_v);
        if (shooter instanceof EntityPlayer) {
            this.field_70251_a = EntityArrow.PickupStatus.ALLOWED;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CRITICAL, (Object)0);
    }

    public void func_184547_a(Entity shooter, float pitch, float yaw, float p_184547_4_, float velocity, float inaccuracy) {
        float f = -MathHelper.func_76126_a((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        float f1 = -MathHelper.func_76126_a((float)(pitch * ((float)Math.PI / 180)));
        float f2 = MathHelper.func_76134_b((float)(yaw * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(pitch * ((float)Math.PI / 180)));
        this.func_70186_c(f, f1, f2, velocity, inaccuracy);
        this.field_70159_w += shooter.field_70159_w;
        this.field_70179_y += shooter.field_70179_y;
        if (!shooter.field_70122_E) {
            this.field_70181_x += shooter.field_70181_x;
        }
    }

    public void func_70186_c(double x, double y, double z, float velocity, float inaccuracy) {
        float f = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
        x /= (double)f;
        y /= (double)f;
        z /= (double)f;
        x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        z += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)inaccuracy;
        this.field_70159_w = x *= (double)velocity;
        this.field_70181_x = y *= (double)velocity;
        this.field_70179_y = z *= (double)velocity;
        float f1 = MathHelper.func_76133_a((double)(x * x + z * z));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f1) * 57.29577951308232);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.ticksInGround = 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(x * x + z * z));
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)y, (double)f) * 57.29577951308232);
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)x, (double)z) * 57.29577951308232);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        if (this.field_70128_L) {
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        super.func_70030_z();
        if (this.bow != null && !this.hasHitGround) {
            this.bow.doArrowTick(this, this.shooter);
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
        BlockPos blockpos = new BlockPos(this.xTile, this.yTile, this.zTile);
        IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
        Block block = iblockstate.func_177230_c();
        if (iblockstate.func_185904_a() != Material.field_151579_a && (axisalignedbb = iblockstate.func_185890_d((IBlockAccess)this.field_70170_p, blockpos)) != Block.field_185506_k && axisalignedbb.func_186670_a(blockpos).func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_70254_i = true;
            this.hasHitGround = true;
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.field_70254_i) {
            int j = block.func_176201_c(iblockstate);
            if (!(block == this.inTile && j == this.inData || this.field_70170_p.func_184143_b(this.func_174813_aQ().func_186662_g(0.05)))) {
                this.field_70254_i = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            } else {
                ++this.ticksInGround;
                if (this.ticksInGround >= 1200) {
                    this.func_70106_y();
                }
            }
            ++this.field_184552_b;
        } else {
            Entity entity;
            this.field_184552_b = 0;
            ++this.ticksInAir;
            Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytraceresult = this.field_70170_p.func_147447_a(vec3d1, vec3d, false, true, false);
            vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytraceresult != null) {
                vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
            }
            if ((entity = this.func_184551_a(vec3d1, vec3d)) != null) {
                raytraceresult = new RayTraceResult(entity);
            }
            if (raytraceresult != null && raytraceresult.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)raytraceresult.field_72308_g;
                if (this.shooter instanceof EntityPlayer && !((EntityPlayer)this.shooter).func_96122_a(entityplayer)) {
                    raytraceresult = null;
                }
            }
            if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((EntityArrow)this, (RayTraceResult)raytraceresult)) {
                this.func_184549_a(raytraceresult);
            }
            if (this.func_70241_g() && !this.hideCriticalParticles()) {
                for (int k = 0; k < 4; ++k) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT, this.field_70165_t + this.field_70159_w * (double)k / 4.0, this.field_70163_u + this.field_70181_x * (double)k / 4.0, this.field_70161_v + this.field_70179_y * (double)k / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y, new int[0]);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f4 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f4) * 57.29577951308232);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f1 = 0.99f;
            if (this.func_70090_H()) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * 0.25, this.field_70163_u - this.field_70181_x * 0.25, this.field_70161_v - this.field_70179_y * 0.25, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f1 = 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f1;
            this.field_70181_x *= (double)f1;
            this.field_70179_y *= (double)f1;
            this.field_70181_x -= (double)this.getGravityVelocity();
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    protected void func_184549_a(RayTraceResult rayTrace) {
        Entity target = rayTrace.field_72308_g;
        if (target != null) {
            if (this.field_70170_p.field_72995_K && target instanceof EntityPlayer && this.ticksInAir <= 3) {
                return;
            }
            float vectoredVelocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            float damage = (float)(this.baseDamage / 1.5) / (3.0f / vectoredVelocity);
            if (this.func_70241_g()) {
                damage += damage / 4.0f + this.field_70146_Z.nextFloat() * (damage / 1.5f);
            }
            DamageSource damageSource = this.shooter == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.shooter);
            if (this.bow != null) {
                damage = this.bow.getArrowDamage(this, target, damage);
            }
            if (this.func_70027_ad() && !(target instanceof EntityEnderman)) {
                target.func_70015_d(5);
            }
            if (target.func_70097_a(damageSource, damage)) {
                if (target instanceof EntityLivingBase) {
                    float motionVector;
                    EntityLivingBase entitylivingbase = (EntityLivingBase)target;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                    if (this.knockbackStrength > 0 && (motionVector = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                        entitylivingbase.func_70024_g(this.field_70159_w * (double)this.knockbackStrength / 2.0 * (double)0.6f / (double)motionVector, 0.1, this.field_70179_y * (double)this.knockbackStrength / 2.0 * (double)0.6f / (double)motionVector);
                    }
                    if (this.shooter instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.shooter);
                        EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.shooter), (Entity)entitylivingbase);
                    }
                    this.func_184548_a(entitylivingbase);
                    if (this.shooter != null && entitylivingbase != this.shooter && entitylivingbase instanceof EntityPlayer && this.shooter instanceof EntityPlayerMP) {
                        ((EntityPlayerMP)this.shooter).field_71135_a.func_147359_a((Packet)new SPacketChangeGameState(6, 0.0f));
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                if (this.bow != null && !this.hasHitGround) {
                    this.bow.doImpactEffect(this, target, this.shooter, damage);
                }
                if (!(target instanceof EntityEnderman)) {
                    this.func_70106_y();
                }
            } else {
                this.field_70159_w *= (double)-0.1f;
                this.field_70181_x *= (double)-0.1f;
                this.field_70179_y *= (double)-0.1f;
                this.field_70177_z += 180.0f;
                this.field_70126_B += 180.0f;
                this.ticksInAir = 0;
                if (!this.field_70170_p.field_72995_K && this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y < (double)0.001f) {
                    if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
                        this.func_70099_a(this.func_184550_j(), 0.1f);
                    }
                    this.func_70106_y();
                }
            }
        } else {
            BlockPos blockpos = rayTrace.func_178782_a();
            this.xTile = blockpos.func_177958_n();
            this.yTile = blockpos.func_177956_o();
            this.zTile = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.inTile = iblockstate.func_177230_c();
            this.inData = this.inTile.func_176201_c(iblockstate);
            this.field_70159_w = (float)(rayTrace.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(rayTrace.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(rayTrace.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.arrowShake = 7;
            this.func_70243_d(false);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.inTile.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
            if (!this.field_70170_p.field_72995_K && this.bow != null && !this.hasHitGround) {
                this.bow.doBlockImpact(this, iblockstate, this.shooter);
            }
            this.hasHitGround = true;
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        super.func_70091_d(type, x, y, z);
        if (this.field_70254_i) {
            this.xTile = MathHelper.func_76128_c((double)this.field_70165_t);
            this.yTile = MathHelper.func_76128_c((double)this.field_70163_u);
            this.zTile = MathHelper.func_76128_c((double)this.field_70161_v);
        }
    }

    public float getGravityVelocity() {
        return 0.05f;
    }

    public boolean hideCriticalParticles() {
        return false;
    }

    protected void func_184548_a(EntityLivingBase target) {
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), ARROW_TARGETS);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.shooter && this.ticksInAir < 5 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.arrowShake <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    public double func_70242_d() {
        return this.baseDamage;
    }

    public void func_70239_b(double damage) {
        this.baseDamage = damage;
    }

    public void func_70243_d(boolean critical) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(CRITICAL);
        if (critical) {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 | 1)));
        } else {
            this.field_70180_af.func_187227_b(CRITICAL, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public boolean func_70241_g() {
        return ((Byte)this.field_70180_af.func_187225_a(CRITICAL) & 1) != 0;
    }

    public void func_190547_a(EntityLivingBase shooter, float mod) {
        int i = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185309_u, (EntityLivingBase)shooter);
        int j = EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185310_v, (EntityLivingBase)shooter);
        this.func_70239_b((double)(mod * 2.0f) + this.field_70146_Z.nextGaussian() * 0.25 + (double)((float)this.field_70170_p.func_175659_aa().func_151525_a() * 0.11f));
        if (i > 0) {
            this.func_70239_b(this.func_70242_d() + (double)i * 0.5 + 0.5);
        }
        if (j > 0) {
            this.func_70240_a(j);
        }
        if (EnchantmentHelper.func_185284_a((Enchantment)Enchantments.field_185311_w, (EntityLivingBase)shooter) > 0) {
            this.func_70015_d(100);
        }
    }

    public void func_70240_a(int knockback) {
        this.knockbackStrength = knockback;
    }

    public int getKnockbackStrength() {
        return this.knockbackStrength;
    }

    protected ItemStack func_184550_j() {
        return new ItemStack((Item)ItemRegister.hollyArrow);
    }

    public Entity getShooter() {
        return this.shooter;
    }

    @Override
    public void doImpactEffect() {
    }

    public BaseBow getShootingBow() {
        return this.bow;
    }
}

