/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.cannon;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.tslat.aoa3.entity.projectiles.HardProjectile;
import net.tslat.aoa3.entity.projectiles.gun.BaseBullet;
import net.tslat.aoa3.item.weapon.gun.BaseGun;
import net.tslat.aoa3.utils.WorldUtil;

public class EntityStickyCoolBomb
extends BaseBullet
implements HardProjectile {
    private BaseGun weapon;
    private EntityLivingBase shooter;
    private int ticksInGround = 0;

    public EntityStickyCoolBomb(World world) {
        super(world);
    }

    public EntityStickyCoolBomb(EntityLivingBase shooter, BaseGun gun, EnumHand hand, int maxAge, int piercingValue) {
        super(shooter, gun, hand, maxAge, 1.0f, piercingValue);
        this.weapon = gun;
        this.shooter = shooter;
    }

    public EntityStickyCoolBomb(World world, double x, double y, double z) {
        super(world, x, y, z);
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
            IBlockState bl = this.field_70170_p.func_180495_p(result.func_178782_a());
            if (!bl.func_185904_a().func_76230_c()) {
                return;
            }
            ++this.ticksInGround;
            this.field_70165_t = result.func_178782_a().func_177958_n();
            this.field_70163_u = result.func_178782_a().func_177956_o();
            this.field_70161_v = result.func_178782_a().func_177952_p();
            this.field_70181_x = 0.0;
            this.field_70159_w = 0.0;
            this.field_70179_y = 0.0;
            switch (result.field_178784_b) {
                case UP: {
                    this.field_70163_u += 1.0;
                    break;
                }
                case DOWN: {
                    this.field_70163_u -= 1.0;
                    break;
                }
                case SOUTH: {
                    this.field_70161_v += 0.5;
                    break;
                }
                case NORTH: {
                    this.field_70161_v -= 0.5;
                    break;
                }
                case EAST: {
                    this.field_70165_t += 0.5;
                    break;
                }
                case WEST: {
                    this.field_70165_t -= 0.5;
                    break;
                }
            }
        } else {
            if (result.field_72308_g != null && !this.field_70170_p.field_72995_K) {
                this.weapon.doImpactDamage(result.field_72308_g, this.func_85052_h(), this, 1.0f);
                this.doImpactEffect();
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
            }
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.ticksInGround > 0) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
            ++this.ticksInGround;
            if (this.ticksInGround >= 80 && !this.field_70170_p.field_72995_K) {
                this.doImpactEffect();
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.field_70128_L = false;
            }
        }
    }

    @Override
    public void doImpactEffect() {
        WorldUtil.createExplosion((Entity)this.field_70192_c, this.field_70170_p, (Entity)this, 2.0f);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }
}

