/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.aoa3.entity.projectiles.staff;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.tslat.aoa3.item.weapon.EnergyProjectileWeapon;

public class BaseEnergyShot
extends EntityThrowable {
    protected int lifespan;
    private int age = 0;
    protected EnergyProjectileWeapon weapon;

    public BaseEnergyShot(World world) {
        super(world);
    }

    public BaseEnergyShot(EntityLivingBase shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, double motionX, double motionY, double motionZ) {
        super(shooter.field_70170_p);
        this.lifespan = 60;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(posX, posY, posZ, 0.0f, 360.0f);
        this.field_70159_w = motionX;
        this.field_70181_x = motionY;
        this.field_70179_y = motionZ;
    }

    public BaseEnergyShot(EntityLivingBase shooter, EnergyProjectileWeapon weapon, double posX, double posY, double posZ, float velocity) {
        super(shooter.field_70170_p);
        this.lifespan = 120;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(posX, posY, posZ, 0.0f, 360.0f);
        this.field_70159_w = this.field_70146_Z.nextGaussian() / 33.0 + 0.03;
        this.field_70181_x = -velocity;
        this.field_70179_y = this.field_70146_Z.nextGaussian() / 33.0 + 0.03;
    }

    public BaseEnergyShot(EntityLivingBase shooter, EnergyProjectileWeapon weapon, int maxAge, float xMod, float yMod, float zMod) {
        super(shooter.field_70170_p);
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        boolean right = true;
        if (shooter instanceof EntityPlayer) {
            if (weapon.getWeaponHand() == EnumHand.MAIN_HAND) {
                if (shooter.func_184591_cq() == EnumHandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == EnumHandSide.RIGHT) {
                right = false;
            }
        }
        if (right) {
            this.func_70107_b(this.field_70165_t - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.field_70165_t + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
        this.func_70186_c((double)(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) + (double)xMod, (double)(-MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI))) + (double)yMod, (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI))) + (double)zMod, 3.0f, 1.0f);
        this.field_70165_t += this.field_70159_w * 0.05;
        this.field_70163_u += this.field_70181_x * 0.05;
        this.field_70161_v += this.field_70179_y * 0.05;
    }

    public BaseEnergyShot(EntityLivingBase shooter, EnergyProjectileWeapon weapon, int maxAge) {
        super(shooter.field_70170_p);
        this.lifespan = maxAge;
        this.weapon = weapon;
        this.field_70192_c = shooter;
        this.field_184539_c = shooter;
        this.func_70012_b(shooter.field_70165_t, shooter.field_70163_u + (double)shooter.func_70047_e(), shooter.field_70161_v, shooter.field_70177_z, shooter.field_70125_A);
        boolean right = true;
        if (shooter instanceof EntityPlayer) {
            if (weapon.getWeaponHand() == EnumHand.MAIN_HAND) {
                if (shooter.func_184591_cq() == EnumHandSide.LEFT) {
                    right = false;
                }
            } else if (shooter.func_184591_cq() == EnumHandSide.RIGHT) {
                right = false;
            }
        }
        if (right) {
            this.func_70107_b(this.field_70165_t - (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v - (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        } else {
            this.func_70107_b(this.field_70165_t + (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f), this.field_70163_u - 0.2, this.field_70161_v + (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.4f));
        }
        this.func_70186_c(-MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI)), MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI)), 3.0f, 1.0f);
        this.field_70165_t += this.field_70159_w * 0.5;
        this.field_70163_u += this.field_70181_x * 0.5;
        this.field_70161_v += this.field_70179_y * 0.5;
    }

    public BaseEnergyShot(World world, double x, double y, double z) {
        super(world);
    }

    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.weapon != null) {
                if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                    this.weapon.doBlockImpact(this, result.func_178782_a(), this.field_70192_c);
                } else if (result.field_72308_g != null) {
                    this.weapon.doEntityImpact(this, result.field_72308_g, this.field_70192_c);
                }
            }
            this.func_70106_y();
        }
    }

    public boolean func_180427_aV() {
        return true;
    }

    public void func_70071_h_() {
        if (this.field_70128_L) {
            return;
        }
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_174854_a || this.age > this.lifespan) {
                this.func_70106_y();
                return;
            }
            ++this.age;
        }
        Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d, vec3d1);
        vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d1 = raytraceresult != null ? new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c) : new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(0.5));
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult1;
            Entity entity1 = (Entity)list.get(i);
            if (!entity1.func_70067_L() || entity1 == this.field_184539_c || (raytraceresult1 = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d, vec3d1)) == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null && !ForgeEventFactory.onProjectileImpact((EntityThrowable)this, (RayTraceResult)raytraceresult)) {
            this.func_70184_a(raytraceresult);
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        this.field_70159_w *= 0.99;
        this.field_70181_x *= 0.99;
        this.field_70179_y *= 0.99;
        this.field_70181_x -= (double)this.func_70185_h();
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public int getAge() {
        return this.age;
    }
}

